/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal;

import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.internal.CurrencyService;
import org.eclipsetrader.core.markets.IMarketService;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class CurrencyServiceFactory
implements ServiceFactory {
    private CurrencyService serviceInstance;

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        if (this.serviceInstance == null) {
            IRepositoryService repositoryService = null;
            IMarketService marketService = null;
            try {
                BundleContext context = CoreActivator.getDefault().getBundle().getBundleContext();
                ServiceReference serviceReference = context.getServiceReference(IRepositoryService.class.getName());
                if (serviceReference != null) {
                    repositoryService = (IRepositoryService)context.getService(serviceReference);
                    context.ungetService(serviceReference);
                }
                if ((serviceReference = context.getServiceReference(IMarketService.class.getName())) != null) {
                    marketService = (IMarketService)context.getService(serviceReference);
                    context.ungetService(serviceReference);
                }
                this.serviceInstance = new CurrencyService(repositoryService, marketService);
                this.serviceInstance.startUp(null);
            }
            catch (Exception e) {
                CoreActivator.log("Error starting currency service", e);
            }
        }
        return this.serviceInstance;
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }

    public void dispose() {
        if (this.serviceInstance != null) {
            try {
                this.serviceInstance.shutDown(null);
            }
            catch (Exception e) {
                CoreActivator.log("Error stopping currency service", e);
            }
        }
    }
}

