/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.ats;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipsetrader.core.ats.ITradingSystemInstrument;
import org.eclipsetrader.core.feed.IQuote;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.trading.IPosition;

public class TradingSystemInstrument
implements ITradingSystemInstrument {
    public static final String PROPERTY_QUOTE = "quote";
    public static final String PROPERTY_TRADE = "trade";
    public static final String PROPERTY_BARS = "bars";
    public static final String PROPERTY_POSITION = "position";
    private final ISecurity instrument;
    private ITrade trade;
    private IQuote quote;
    private IPosition position;
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public TradingSystemInstrument(ISecurity instrument) {
        this.instrument = instrument;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public ISecurity getInstrument() {
        return this.instrument;
    }

    public IPosition getPosition() {
        return this.position;
    }

    public void setPosition(IPosition position) {
        this.position = position;
        this.changeSupport.firePropertyChange(PROPERTY_POSITION, this.position, this.position);
    }

    public ITrade getTrade() {
        return this.trade;
    }

    public void setTrade(ITrade trade) {
        this.trade = trade;
        this.changeSupport.firePropertyChange(PROPERTY_TRADE, this.trade, this.trade);
    }

    public IQuote getQuote() {
        return this.quote;
    }

    public void setQuote(IQuote quote) {
        this.quote = quote;
        this.changeSupport.firePropertyChange(PROPERTY_TRADE, this.quote, this.quote);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.instrument.getClass())) {
            return this.instrument;
        }
        if (adapter.isAssignableFrom(IPosition.class)) {
            return this.position;
        }
        if (this.position != null && adapter.isAssignableFrom(this.position.getClass())) {
            return this.position;
        }
        if (adapter.isAssignableFrom(ITrade.class)) {
            return this.trade;
        }
        if (this.trade != null && adapter.isAssignableFrom(this.trade.getClass())) {
            return this.trade;
        }
        if (adapter.isAssignableFrom(IQuote.class)) {
            return this.quote;
        }
        if (this.quote != null && adapter.isAssignableFrom(this.quote.getClass())) {
            return this.quote;
        }
        if (adapter.isAssignableFrom(this.changeSupport.getClass())) {
            return this.changeSupport;
        }
        Object result = this.instrument.getAdapter(adapter);
        if (result != null) {
            return result;
        }
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }
}

