/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.ats;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.ILauncher;
import org.eclipsetrader.core.ats.ITradingSystemService;
import org.eclipsetrader.core.internal.CoreActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class TradingSystemsLauncher
implements ILauncher,
IExecutableExtension {
    private String id;
    private String name;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.id = config.getAttribute("id");
        this.name = config.getAttribute("name");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void launch(IProgressMonitor monitor) {
        try {
            BundleContext context = CoreActivator.getDefault().getBundle().getBundleContext();
            ServiceReference serviceReference = context.getServiceReference(ITradingSystemService.class);
            if (serviceReference != null) {
                ITradingSystemService service = (ITradingSystemService)context.getService(serviceReference);
                service.start();
                context.ungetService(serviceReference);
            }
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipsetrader.core", 0, "Error starting trading system service", (Throwable)e);
            CoreActivator.log((IStatus)status);
        }
    }

    @Override
    public void terminate(IProgressMonitor monitor) {
        try {
            BundleContext context = CoreActivator.getDefault().getBundle().getBundleContext();
            ServiceReference serviceReference = context.getServiceReference(ITradingSystemService.class);
            if (serviceReference != null) {
                ITradingSystemService service = (ITradingSystemService)context.getService(serviceReference);
                service.stop();
                context.ungetService(serviceReference);
            }
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipsetrader.core", 0, "Error stopping trading system service", (Throwable)e);
            CoreActivator.log((IStatus)status);
        }
    }
}

