/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.ats.repository;

import java.net.URI;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipsetrader.core.internal.ats.TradingSystemProperties;
import org.eclipsetrader.core.internal.ats.repository.BrokerAdapter;
import org.eclipsetrader.core.trading.IAccount;
import org.eclipsetrader.core.trading.IBroker;

@XmlRootElement(name="settings")
public class Settings {
    @XmlAttribute(name="autostart")
    private boolean autostart;
    @XmlElement(name="uri")
    private URI uri;
    @XmlElement(name="broker")
    @XmlJavaTypeAdapter(value=BrokerAdapter.class)
    private IBroker broker;
    @XmlElement(name="account")
    private String account;
    @XmlElement(name="backfill")
    private int backfill;

    public Settings() {
    }

    public Settings(URI uri, TradingSystemProperties properties) {
        this.uri = uri;
        this.autostart = properties.isAutostart();
        this.broker = properties.getBroker();
        this.account = properties.getAccount() != null ? properties.getAccount().getId() : null;
        this.backfill = properties.getBackfill();
    }

    @XmlTransient
    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI strategy) {
        this.uri = strategy;
    }

    @XmlTransient
    public boolean isAutostart() {
        return this.autostart;
    }

    public void setAutostart(boolean autostart) {
        this.autostart = autostart;
    }

    @XmlTransient
    public IBroker getBroker() {
        return this.broker;
    }

    @XmlTransient
    public IAccount getAccount() {
        if (this.broker == null || this.account == null) {
            return null;
        }
        IAccount[] iAccountArray = this.broker.getAccounts();
        int n = iAccountArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAccount account = iAccountArray[n2];
            if (account.getId().equals(this.account)) {
                return account;
            }
            ++n2;
        }
        return null;
    }

    @XmlTransient
    public TradingSystemProperties getProperties() {
        TradingSystemProperties properties = new TradingSystemProperties();
        properties.setAutostart(this.autostart);
        properties.setBroker(this.broker);
        properties.setAccount(this.getAccount());
        properties.setBackfill(this.backfill);
        return properties;
    }
}

