/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.ats.repository;

import java.net.URI;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.eclipsetrader.core.ats.IStrategy;
import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class StrategyAdapter
extends XmlAdapter<String, IStrategy> {
    public String marshal(IStrategy v) throws Exception {
        if (v == null) {
            return null;
        }
        URI uri = (URI)v.getAdapter(URI.class);
        if (uri != null) {
            return uri.toString();
        }
        IStoreObject storeObject = (IStoreObject)v.getAdapter(IStoreObject.class);
        return storeObject != null ? storeObject.getStore().toURI().toString() : null;
    }

    public IStrategy unmarshal(String v) throws Exception {
        if (v == null) {
            return null;
        }
        BundleContext context = CoreActivator.getDefault().getBundle().getBundleContext();
        ServiceReference serviceRef = context.getServiceReference(IRepositoryService.class);
        try {
            IRepositoryService repositoryService = (IRepositoryService)context.getService(serviceRef);
            IStoreObject storeObject = repositoryService.getObjectFromURI(new URI(v));
            if (storeObject instanceof IStrategy) {
                IStrategy iStrategy = (IStrategy)((Object)storeObject);
                return iStrategy;
            }
        }
        finally {
            context.ungetService(serviceRef);
        }
        return null;
    }
}

