/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.charts.repository;

import java.util.UUID;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipsetrader.core.charts.repository.IChartSection;
import org.eclipsetrader.core.charts.repository.IChartVisitor;
import org.eclipsetrader.core.charts.repository.IElementSection;
import org.eclipsetrader.core.charts.repository.ISecuritySection;
import org.eclipsetrader.core.internal.charts.repository.ElementSectionAdapter;
import org.eclipsetrader.core.internal.charts.repository.SecuritySection;

@XmlRootElement(name="section")
public class ChartSection
implements IChartSection {
    @XmlAttribute(name="id")
    private String id;
    @XmlAttribute(name="name")
    private String name;
    @XmlElementRef
    @XmlJavaTypeAdapter(value=ElementSectionAdapter.class)
    private IElementSection[] indicators;
    @XmlElement(name="security")
    @XmlJavaTypeAdapter(value=SecuritySectionAdapter.class)
    private ISecuritySection[] securities;

    public ChartSection() {
    }

    public ChartSection(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public ChartSection(String name) {
        this.id = UUID.randomUUID().toString();
        this.name = name;
    }

    public ChartSection(IChartSection section) {
        this.id = section.getId();
        this.name = section.getName();
        this.indicators = section.getElements();
        this.securities = section.getSecurities();
    }

    @Override
    @XmlTransient
    public String getId() {
        return this.id;
    }

    @Override
    @XmlTransient
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @XmlTransient
    public IElementSection[] getElements() {
        return this.indicators != null ? this.indicators : new IElementSection[]{};
    }

    @Override
    public void setElements(IElementSection[] indicators) {
        this.indicators = indicators;
    }

    @Override
    @XmlTransient
    public ISecuritySection[] getSecurities() {
        return this.securities != null ? this.securities : new ISecuritySection[]{};
    }

    @Override
    public void setSecurities(ISecuritySection[] securities) {
        this.securities = securities;
    }

    @Override
    public void accept(IChartVisitor visitor) {
        if (visitor.visit(this)) {
            ISecuritySection[] s = this.getSecurities();
            int i = 0;
            while (i < s.length) {
                s[i].accept(visitor);
                ++i;
            }
            IElementSection[] d = this.getElements();
            int i2 = 0;
            while (i2 < d.length) {
                d[i2].accept(visitor);
                ++i2;
            }
        }
    }

    public static class SecuritySectionAdapter
    extends XmlAdapter<SecuritySection, ISecuritySection> {
        public SecuritySection marshal(ISecuritySection v) throws Exception {
            if (v instanceof SecuritySection) {
                return (SecuritySection)v;
            }
            return v != null ? new SecuritySection(v) : null;
        }

        public ISecuritySection unmarshal(SecuritySection v) throws Exception {
            return v;
        }
    }
}

