/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.feed;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.feed.IBackfillConnector;
import org.eclipsetrader.core.feed.IFeedConnector;
import org.eclipsetrader.core.feed.IFeedService;
import org.eclipsetrader.core.internal.CoreActivator;

public class FeedService
implements IFeedService {
    private static final String EXTENSION_ID = "connectors";
    private static final String CONNECTOR_ELEMENT = "connector";
    private static final String BACKFILL_ELEMENT = "backfill";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    private Map<String, IFeedConnector> connectors = new HashMap<String, IFeedConnector>();
    private Map<String, IBackfillConnector> backfillConnectors = new HashMap<String, IBackfillConnector>();

    public void startUp() {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipsetrader.core", EXTENSION_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object connector;
                String id = element.getAttribute(ID_ATTRIBUTE);
                if (element.getName().equals(CONNECTOR_ELEMENT)) {
                    connector = (IFeedConnector)element.createExecutableExtension(CLASS_ATTRIBUTE);
                    this.connectors.put(id, (IFeedConnector)connector);
                    if (connector instanceof IBackfillConnector) {
                        this.backfillConnectors.put(id, (IBackfillConnector)connector);
                    }
                }
                if (element.getName().equals(BACKFILL_ELEMENT)) {
                    connector = (IBackfillConnector)element.createExecutableExtension(CLASS_ATTRIBUTE);
                    this.backfillConnectors.put(id, (IBackfillConnector)connector);
                }
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipsetrader.core", 0, "Error creating connector " + element.getAttribute(ID_ATTRIBUTE), (Throwable)e);
                CoreActivator.getDefault().getLog().log((IStatus)status);
            }
            ++n2;
        }
    }

    public void shutDown() {
        for (IFeedConnector connector : this.connectors.values()) {
            connector.disconnect();
        }
    }

    @Override
    public IFeedConnector getConnector(String id) {
        return this.connectors.get(id);
    }

    @Override
    public IFeedConnector[] getConnectors() {
        Collection<IFeedConnector> values = this.connectors.values();
        return values.toArray(new IFeedConnector[values.size()]);
    }

    @Override
    public IBackfillConnector getBackfillConnector(String id) {
        return this.backfillConnectors.get(id);
    }

    @Override
    public IBackfillConnector[] getBackfillConnectors() {
        Collection<IBackfillConnector> values = this.backfillConnectors.values();
        return values.toArray(new IBackfillConnector[values.size()]);
    }
}

