/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.markets;

import java.util.Date;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.feed.IBackfillConnector;
import org.eclipsetrader.core.feed.IDividend;
import org.eclipsetrader.core.feed.IFeedIdentifier;
import org.eclipsetrader.core.feed.IFeedService;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.core.feed.ISplit;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.core.internal.CoreActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class BackfillConnectorAdapter
extends XmlAdapter<String, IBackfillConnector> {
    public String marshal(IBackfillConnector v) throws Exception {
        return v != null ? v.getId() : null;
    }

    public IBackfillConnector unmarshal(String v) throws Exception {
        if (v == null) {
            return null;
        }
        IBackfillConnector connector = null;
        try {
            BundleContext context = CoreActivator.getDefault().getBundle().getBundleContext();
            ServiceReference serviceReference = context.getServiceReference(IFeedService.class.getName());
            IFeedService feedService = (IFeedService)context.getService(serviceReference);
            connector = feedService.getBackfillConnector(v);
            context.ungetService(serviceReference);
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipsetrader.core", 0, "Error reading feed service", (Throwable)e);
            CoreActivator.log((IStatus)status);
        }
        return connector;
    }

    public class FailsafeBackfillConnector
    implements IBackfillConnector {
        private String id;

        public FailsafeBackfillConnector(String id) {
            this.id = id;
        }

        @Override
        public IDividend[] backfillDividends(IFeedIdentifier identifier, Date from, Date to) {
            return null;
        }

        @Override
        public IOHLC[] backfillHistory(IFeedIdentifier identifier, Date from, Date to, TimeSpan timeSpan) {
            return null;
        }

        @Override
        public ISplit[] backfillSplits(IFeedIdentifier identifier, Date from, Date to) {
            return null;
        }

        @Override
        public boolean canBackfill(IFeedIdentifier identifier, TimeSpan timeSpan) {
            return false;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return null;
        }
    }
}

