/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.markets;

import java.util.Calendar;
import java.util.Date;
import org.eclipsetrader.core.markets.IMarketDay;

public class MarketDay
implements IMarketDay {
    private Date openTime;
    private Date closeTime;
    private String message;

    public MarketDay(Date openTime, Date closeTime, String message) {
        this.openTime = openTime;
        this.closeTime = closeTime;
        this.message = message;
    }

    @Override
    public Date getOpenTime() {
        return this.openTime;
    }

    @Override
    public Date getCloseTime() {
        return this.closeTime;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen(Calendar.getInstance().getTime());
    }

    @Override
    public boolean isOpen(Date time) {
        if (this.openTime == null || this.closeTime == null) {
            return false;
        }
        return (time.equals(this.openTime) || time.after(this.openTime)) && time.before(this.closeTime);
    }
}

