/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.markets;

import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipsetrader.core.internal.markets.DateAdapter;
import org.eclipsetrader.core.internal.markets.TimeAdapter;

@XmlRootElement(name="day")
@XmlType(name="org.eclipsetrader.core.markets.MarketHoliday")
public class MarketHoliday
implements Comparable<MarketHoliday> {
    @XmlAttribute(name="date")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date date;
    @XmlValue
    private String description;
    @XmlAttribute(name="open")
    @XmlJavaTypeAdapter(value=TimeAdapter.class)
    private Date openTime;
    @XmlAttribute(name="close")
    @XmlJavaTypeAdapter(value=TimeAdapter.class)
    private Date closeTime;

    protected MarketHoliday() {
    }

    public MarketHoliday(Date date, String description) {
        this(date, description, null, null);
    }

    public MarketHoliday(Date openTime, Date closeTime, String description) {
        this(openTime, description, openTime, closeTime);
    }

    public MarketHoliday(Date date, String description, Date openTime, Date closeTime) {
        this.date = date;
        this.description = description;
        this.openTime = openTime;
        this.closeTime = closeTime;
    }

    public String getDescription() {
        return this.description;
    }

    @XmlTransient
    public Date getDate() {
        return this.date;
    }

    @XmlTransient
    public Date getOpenTime() {
        if (this.openTime == null) {
            return null;
        }
        Calendar today = Calendar.getInstance();
        if (this.date != null) {
            today.setTime(this.date);
        }
        Calendar openTime = Calendar.getInstance();
        openTime.setTime(this.openTime);
        openTime.set(5, today.get(5));
        openTime.set(2, today.get(2));
        openTime.set(1, today.get(1));
        openTime.set(13, 0);
        openTime.set(14, 0);
        return openTime.getTime();
    }

    @XmlTransient
    public Date getCloseTime() {
        if (this.closeTime == null) {
            return null;
        }
        Calendar today = Calendar.getInstance();
        if (this.date != null) {
            today.setTime(this.date);
        }
        Calendar closeTime = Calendar.getInstance();
        closeTime.setTime(this.closeTime);
        closeTime.set(5, today.get(5));
        closeTime.set(2, today.get(2));
        closeTime.set(1, today.get(1));
        closeTime.set(13, 0);
        closeTime.set(14, 0);
        return closeTime.getTime();
    }

    @Override
    public int compareTo(MarketHoliday o) {
        return this.date.compareTo(o.date);
    }
}

