/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.repositories;

import java.lang.reflect.Constructor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipsetrader.core.IScript;
import org.eclipsetrader.core.Script;
import org.eclipsetrader.core.ats.IScriptStrategy;
import org.eclipsetrader.core.ats.ScriptStrategy;
import org.eclipsetrader.core.feed.History;
import org.eclipsetrader.core.feed.IHistory;
import org.eclipsetrader.core.instruments.CurrencyExchange;
import org.eclipsetrader.core.instruments.ICurrencyExchange;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.instruments.IStock;
import org.eclipsetrader.core.instruments.Security;
import org.eclipsetrader.core.instruments.Stock;
import org.eclipsetrader.core.repositories.IRepositoryElementFactory;
import org.eclipsetrader.core.repositories.IStore;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.eclipsetrader.core.repositories.IStoreProperties;
import org.eclipsetrader.core.views.Holding;
import org.eclipsetrader.core.views.IHolding;
import org.eclipsetrader.core.views.IWatchList;
import org.eclipsetrader.core.views.WatchList;

public class DefaultElementFactory
implements IRepositoryElementFactory,
IExecutableExtension {
    private static DefaultElementFactory instance;
    private String id;

    protected DefaultElementFactory() {
    }

    public static DefaultElementFactory getInstance() {
        if (instance == null) {
            instance = new DefaultElementFactory();
        }
        return instance;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.id = config.getAttribute("id");
        if (instance == null) {
            instance = this;
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IStoreObject createElement(IStore store, IStoreProperties properties) {
        String type = (String)properties.getProperty("type");
        if (type != null) {
            if (ICurrencyExchange.class.getName().equals(type)) {
                return new CurrencyExchange(store, properties);
            }
            if (ISecurity.class.getName().equals(type)) {
                return new Security(store, properties);
            }
            if (IStock.class.getName().equals(type)) {
                return new Stock(store, properties);
            }
            if (IWatchList.class.getName().equals(type)) {
                return new WatchList(store, properties);
            }
            if (IHistory.class.getName().equals(type)) {
                return new History(store, properties);
            }
            if (IHolding.class.getName().equals(type)) {
                return new Holding(store, properties);
            }
            if (IScript.class.getName().equals(type)) {
                return new Script(store, properties);
            }
            if (IScriptStrategy.class.getName().equals(type)) {
                return new ScriptStrategy(store, properties);
            }
            try {
                Constructor<?> constructor;
                Class<?> clazz = Class.forName(type);
                if (!clazz.isInterface() && (constructor = clazz.getConstructor(IStore.class, IStoreProperties.class)) != null) {
                    return (IStoreObject)constructor.newInstance(store, properties);
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }
}

