/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.repositories;

import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipsetrader.core.feed.History;
import org.eclipsetrader.core.feed.IFeedIdentifier;
import org.eclipsetrader.core.feed.IHistory;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.internal.repositories.DefaultElementFactory;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IRepositoryChangeListener;
import org.eclipsetrader.core.repositories.IRepositoryElementFactory;
import org.eclipsetrader.core.repositories.IRepositoryProvider;
import org.eclipsetrader.core.repositories.IRepositoryRunnable;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.repositories.IStore;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.eclipsetrader.core.repositories.IStoreProperties;
import org.eclipsetrader.core.repositories.RepositoryChangeEvent;
import org.eclipsetrader.core.repositories.RepositoryResourceDelta;
import org.eclipsetrader.core.views.IHolding;
import org.eclipsetrader.core.views.IWatchList;
import org.eclipsetrader.core.views.IWatchListElement;
import org.eclipsetrader.core.views.WatchList;

public class RepositoryService
implements IRepositoryService {
    private Map<String, IRepository> repositoryMap = new HashMap<String, IRepository>();
    private Map<URI, IStoreObject> objectsMap = new HashMap<URI, IStoreObject>();
    private Map<URI, ISecurity> uriMap = new HashMap<URI, ISecurity>();
    private Map<String, ISecurity> nameMap = new HashMap<String, ISecurity>();
    private Map<String, IFeedIdentifier> identifiersMap = new HashMap<String, IFeedIdentifier>();
    private Map<URI, IWatchList> watchlistUriMap = new HashMap<URI, IWatchList>();
    private Map<String, IWatchList> watchlistNameMap = new HashMap<String, IWatchList>();
    private Map<ISecurity, WeakReference<IHistory>> historyMap = new HashMap<ISecurity, WeakReference<IHistory>>();
    private List<IHolding> trades = new ArrayList<IHolding>();
    private IJobManager jobManager;
    private final ILock lock;
    private ListenerList listeners = new ListenerList(1);
    private List<RepositoryResourceDelta> deltas;

    public RepositoryService() {
        this.jobManager = Job.getJobManager();
        this.lock = this.jobManager.newLock();
    }

    @Override
    public IRepository[] getRepositories() {
        Collection<IRepository> c = this.repositoryMap.values();
        return c.toArray(new IRepository[c.size()]);
    }

    @Override
    public IRepository getRepository(String scheme) {
        return this.repositoryMap.get(scheme);
    }

    @Override
    public ISecurity[] getSecurities() {
        Collection<ISecurity> c = this.uriMap.values();
        return c.toArray(new ISecurity[c.size()]);
    }

    @Override
    public ISecurity getSecurityFromName(String name) {
        return this.nameMap.get(name);
    }

    @Override
    public ISecurity getSecurityFromURI(URI uri) {
        IStoreObject element;
        IStore store;
        if (this.uriMap.containsKey(uri)) {
            return this.uriMap.get(uri);
        }
        String schema = uri.getScheme();
        IRepository repository = this.getRepository(schema);
        if (repository != null && (store = repository.getObject(uri)) != null && (element = this.createElement(store, store.fetchProperties(null))) instanceof ISecurity) {
            this.putSecurity(store, (ISecurity)((Object)element));
            return (ISecurity)((Object)element);
        }
        return null;
    }

    @Override
    public IHistory getHistoryFor(ISecurity security) {
        IStoreObject storeObject;
        IHistory history;
        WeakReference<IHistory> reference = this.historyMap.get(security);
        IHistory iHistory = history = reference != null ? (IHistory)reference.get() : null;
        if (history == null && (storeObject = (IStoreObject)security.getAdapter(IStoreObject.class)) != null && storeObject.getStore() != null) {
            IStore[] stores = storeObject.getStore().fetchChilds(null);
            int i = 0;
            while (i < stores.length) {
                IStoreObject object = this.createElement(stores[i], stores[i].fetchProperties(null));
                if (object instanceof IHistory) {
                    history = (IHistory)((Object)object);
                    this.historyMap.put(security, new WeakReference<IHistory>(history));
                    break;
                }
                ++i;
            }
        }
        if (history == null) {
            history = new History(security, new IOHLC[0]);
            this.historyMap.put(security, new WeakReference<IHistory>(history));
        }
        return history;
    }

    @Override
    public IWatchList[] getWatchLists() {
        Collection<IWatchList> c = this.watchlistUriMap.values();
        return c.toArray(new IWatchList[c.size()]);
    }

    @Override
    public IWatchList getWatchListFromName(String name) {
        return this.watchlistNameMap.get(name);
    }

    @Override
    public IWatchList getWatchListFromURI(URI uri) {
        IStoreObject element;
        IStore store;
        if (this.watchlistUriMap.containsKey(uri)) {
            return this.watchlistUriMap.get(uri);
        }
        String schema = uri.getScheme();
        IRepository repository = this.getRepository(schema);
        if (repository != null && (store = repository.getObject(uri)) != null && (element = this.createElement(store, store.fetchProperties(null))) instanceof IWatchList) {
            this.putWatchList(store, (IWatchList)((Object)element));
            return (IWatchList)((Object)element);
        }
        return null;
    }

    @Override
    public IHolding[] getTrades() {
        return this.trades.toArray(new IHolding[this.trades.size()]);
    }

    @Override
    public void deleteAdaptable(IAdaptable[] adaptables) {
        HashMap<IRepository, HashSet<IAdaptable>> repositories = new HashMap<IRepository, HashSet<IAdaptable>>();
        HashMap rules = new HashMap();
        IAdaptable[] iAdaptableArray = adaptables;
        int n = adaptables.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                IStoreObject object;
                IStoreObject[] storeObjects;
                IAdaptable adaptable;
                block11: {
                    adaptable = iAdaptableArray[n2];
                    storeObjects = (IStoreObject[])adaptable.getAdapter(IStoreObject[].class);
                    if (storeObjects != null) break block11;
                    object = (IStoreObject)adaptable.getAdapter(IStoreObject.class);
                    if (object == null) break block12;
                    storeObjects = new IStoreObject[]{object};
                }
                IStoreObject[] iStoreObjectArray = storeObjects;
                int n3 = storeObjects.length;
                int n4 = 0;
                while (n4 < n3) {
                    object = iStoreObjectArray[n4];
                    IStore store = object.getStore();
                    if (store != null) {
                        IRepository repository = store.getRepository();
                        HashSet<IAdaptable> objectSet = (HashSet<IAdaptable>)repositories.get(repository);
                        if (objectSet == null) {
                            objectSet = new HashSet<IAdaptable>();
                            repositories.put(repository, objectSet);
                        }
                        objectSet.add(adaptable);
                        HashSet<ISchedulingRule> ruleSet = (HashSet<ISchedulingRule>)rules.get(repository);
                        if (ruleSet == null) {
                            ruleSet = new HashSet<ISchedulingRule>();
                            rules.put(repository, ruleSet);
                        }
                        if (repository instanceof ISchedulingRule) {
                            ruleSet.add((ISchedulingRule)repository);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        HashSet saveCascade = new HashSet();
        for (IRepository repository : repositories.keySet()) {
            Set ruleSet;
            MultiRule rule;
            Set set;
            IStatus status = repository.runInRepository(new IRepositoryRunnable(set = (Set)repositories.get(repository), saveCascade){
                private final /* synthetic */ Set val$set;
                private final /* synthetic */ Set val$saveCascade;
                {
                    this.val$set = set;
                    this.val$saveCascade = set2;
                }

                @Override
                public IStatus run(IProgressMonitor monitor) throws Exception {
                    try {
                        for (IAdaptable adaptable : this.val$set) {
                            IStoreObject object;
                            if (monitor != null && monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            IStoreObject[] storeObjects = (IStoreObject[])adaptable.getAdapter(IStoreObject[].class);
                            if (storeObjects == null) {
                                object = (IStoreObject)adaptable.getAdapter(IStoreObject.class);
                                if (object == null) continue;
                                storeObjects = new IStoreObject[]{object};
                            }
                            IStoreObject[] iStoreObjectArray = storeObjects;
                            int n = storeObjects.length;
                            int n2 = 0;
                            while (n2 < n) {
                                object = iStoreObjectArray[n2];
                                IStore store = object.getStore();
                                if (store != null) {
                                    store.delete(monitor);
                                    object.setStore(null);
                                    RepositoryService.this.uriMap.remove(store.toURI());
                                    if (adaptable instanceof ISecurity) {
                                        RepositoryService.this.nameMap.remove(((ISecurity)adaptable).getName());
                                        Set<IAdaptable> containers = RepositoryService.this.removeSecurityFromContainers((ISecurity)adaptable);
                                        this.val$saveCascade.addAll(containers);
                                        RepositoryService.this.historyMap.remove(adaptable);
                                    }
                                    if (adaptable instanceof IWatchList) {
                                        RepositoryService.this.watchlistUriMap.remove(store.toURI());
                                        RepositoryService.this.watchlistNameMap.remove(((IWatchList)adaptable).getName());
                                    }
                                    if (adaptable instanceof IHolding) {
                                        RepositoryService.this.trades.remove(adaptable);
                                    }
                                    if (RepositoryService.this.deltas != null) {
                                        int kind = 4098;
                                        RepositoryService.this.deltas.add(new RepositoryResourceDelta(kind, adaptable, store.getRepository(), null, null, null));
                                    }
                                }
                                ++n2;
                            }
                        }
                    }
                    catch (Exception e) {
                        Status status = new Status(4, "org.eclipsetrader.core", 0, "Error deleting object", (Throwable)e);
                        CoreActivator.getDefault().getLog().log((IStatus)status);
                        return status;
                    }
                    catch (LinkageError e) {
                        Status status = new Status(4, "org.eclipsetrader.core", 0, "Error deleting object", (Throwable)e);
                        CoreActivator.getDefault().getLog().log((IStatus)status);
                        return status;
                    }
                    return Status.OK_STATUS;
                }
            }, (ISchedulingRule)(rule = new MultiRule((ruleSet = (Set)rules.get(repository)).toArray(new ISchedulingRule[ruleSet.size()]))), null);
            if (status == Status.CANCEL_STATUS) break;
        }
        if (saveCascade.size() != 0) {
            this.saveAdaptable(saveCascade.toArray(new IAdaptable[saveCascade.size()]));
        }
    }

    protected Set<IAdaptable> removeSecurityFromContainers(ISecurity security) {
        HashSet<IAdaptable> saveCascade = new HashSet<IAdaptable>();
        for (IWatchList list : this.watchlistUriMap.values()) {
            IWatchListElement[] elements;
            if (!(list instanceof WatchList) || (elements = list.getItem(security)) == null || elements.length == 0) continue;
            ArrayList<IWatchListElement> allElements = new ArrayList<IWatchListElement>();
            allElements.addAll(Arrays.asList(list.getItems()));
            allElements.removeAll(Arrays.asList(elements));
            ((WatchList)list).setItems(allElements.toArray(new IWatchListElement[allElements.size()]));
            saveCascade.add(list);
        }
        return saveCascade;
    }

    @Override
    public void saveAdaptable(IAdaptable[] adaptables) {
        this.saveAdaptable(adaptables, this.getRepository("local"));
    }

    @Override
    public void saveAdaptable(IAdaptable[] adaptables, IRepository defaultRepository) {
        HashMap<IRepository, HashSet<IAdaptable>> repositories = new HashMap<IRepository, HashSet<IAdaptable>>();
        HashMap rules = new HashMap();
        IAdaptable[] iAdaptableArray = adaptables;
        int n = adaptables.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                IStoreObject object;
                IStoreObject[] storeObjects;
                IAdaptable adaptable;
                block10: {
                    adaptable = iAdaptableArray[n2];
                    storeObjects = (IStoreObject[])adaptable.getAdapter(IStoreObject[].class);
                    if (storeObjects != null) break block10;
                    object = (IStoreObject)adaptable.getAdapter(IStoreObject.class);
                    if (object == null) break block11;
                    storeObjects = new IStoreObject[]{object};
                }
                IStoreObject[] iStoreObjectArray = storeObjects;
                int n3 = storeObjects.length;
                int n4 = 0;
                while (n4 < n3) {
                    HashSet<IAdaptable> objectSet;
                    object = iStoreObjectArray[n4];
                    IRepository repository = defaultRepository;
                    IStore store = object.getStore();
                    if (store != null && store.getRepository() != null) {
                        repository = store.getRepository();
                    }
                    if ((objectSet = (HashSet<IAdaptable>)repositories.get(repository)) == null) {
                        objectSet = new HashSet<IAdaptable>();
                        repositories.put(repository, objectSet);
                    }
                    objectSet.add(adaptable);
                    HashSet<ISchedulingRule> ruleSet = (HashSet<ISchedulingRule>)rules.get(repository);
                    if (ruleSet == null) {
                        ruleSet = new HashSet<ISchedulingRule>();
                        rules.put(repository, ruleSet);
                    }
                    if (repository instanceof ISchedulingRule) {
                        ruleSet.add((ISchedulingRule)repository);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        for (IRepository r : repositories.keySet()) {
            Set ruleSet;
            MultiRule rule;
            Set set;
            IRepository repository = r;
            IStatus status = repository.runInRepository(new IRepositoryRunnable(set = (Set)repositories.get(repository), repository){
                private final /* synthetic */ Set val$set;
                private final /* synthetic */ IRepository val$repository;
                {
                    this.val$set = set;
                    this.val$repository = iRepository;
                }

                @Override
                public IStatus run(IProgressMonitor monitor) throws Exception {
                    try {
                        for (IAdaptable adaptable : this.val$set) {
                            IStoreObject object;
                            if (monitor != null && monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            IStoreObject[] storeObjects = (IStoreObject[])adaptable.getAdapter(IStoreObject[].class);
                            if (storeObjects == null) {
                                object = (IStoreObject)adaptable.getAdapter(IStoreObject.class);
                                storeObjects = new IStoreObject[]{object};
                            }
                            IStoreObject[] iStoreObjectArray = storeObjects;
                            int n = storeObjects.length;
                            int n2 = 0;
                            while (n2 < n) {
                                object = iStoreObjectArray[n2];
                                int kind = 8192;
                                IStore store = object.getStore();
                                if (store == null) {
                                    store = this.val$repository.createObject();
                                    kind |= 1;
                                } else {
                                    kind |= 4;
                                }
                                IStoreProperties properties = object.getStoreProperties();
                                store.putProperties(properties, monitor);
                                object.setStore(store);
                                if (adaptable instanceof ISecurity) {
                                    RepositoryService.this.uriMap.put(store.toURI(), (ISecurity)adaptable);
                                    RepositoryService.this.nameMap.put(((ISecurity)adaptable).getName(), (ISecurity)adaptable);
                                }
                                if (adaptable instanceof IWatchList) {
                                    RepositoryService.this.watchlistUriMap.put(store.toURI(), (IWatchList)adaptable);
                                    RepositoryService.this.watchlistNameMap.put(((IWatchList)adaptable).getName(), (IWatchList)adaptable);
                                }
                                if (adaptable instanceof IHolding) {
                                    RepositoryService.this.trades.add((IHolding)adaptable);
                                }
                                if (RepositoryService.this.deltas != null) {
                                    RepositoryService.this.deltas.add(new RepositoryResourceDelta(kind, adaptable, null, store.getRepository(), null, properties));
                                }
                                ++n2;
                            }
                        }
                    }
                    catch (Exception e) {
                        Status status = new Status(4, "org.eclipsetrader.core", 0, "Error saving object", (Throwable)e);
                        CoreActivator.getDefault().getLog().log((IStatus)status);
                        return status;
                    }
                    catch (LinkageError e) {
                        Status status = new Status(4, "org.eclipsetrader.core", 0, "Error saving object", (Throwable)e);
                        CoreActivator.getDefault().getLog().log((IStatus)status);
                        return status;
                    }
                    return Status.OK_STATUS;
                }
            }, (ISchedulingRule)(rule = new MultiRule((ruleSet = (Set)rules.get(repository)).toArray(new ISchedulingRule[ruleSet.size()]))), null);
            if (status == Status.CANCEL_STATUS) break;
        }
    }

    @Override
    public void moveAdaptable(final IAdaptable[] adaptables, final IRepository destination) {
        ArrayList<ISchedulingRule> rules = new ArrayList<ISchedulingRule>();
        if (destination instanceof ISchedulingRule) {
            rules.add((ISchedulingRule)destination);
        }
        IAdaptable[] iAdaptableArray = adaptables;
        int n = adaptables.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                IStoreObject object;
                IStoreObject[] storeObjects;
                block7: {
                    IAdaptable adaptable = iAdaptableArray[n2];
                    storeObjects = (IStoreObject[])adaptable.getAdapter(IStoreObject[].class);
                    if (storeObjects != null) break block7;
                    object = (IStoreObject)adaptable.getAdapter(IStoreObject.class);
                    if (object == null) break block8;
                    storeObjects = new IStoreObject[]{object};
                }
                IStoreObject[] iStoreObjectArray = storeObjects;
                int n3 = storeObjects.length;
                int n4 = 0;
                while (n4 < n3) {
                    object = iStoreObjectArray[n4];
                    IStore store = object.getStore();
                    if (store != null && store.getRepository() instanceof ISchedulingRule) {
                        rules.add((ISchedulingRule)store.getRepository());
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        destination.runInRepository(new IRepositoryRunnable(){

            @Override
            public IStatus run(IProgressMonitor monitor) throws Exception {
                try {
                    IAdaptable[] iAdaptableArray = adaptables;
                    int n = adaptables.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block22: {
                            IHistory history;
                            IStoreObject[] storeObjects;
                            IAdaptable adaptable;
                            block21: {
                                adaptable = iAdaptableArray[n2];
                                if (monitor != null && monitor.isCanceled()) {
                                    return Status.CANCEL_STATUS;
                                }
                                storeObjects = (IStoreObject[])adaptable.getAdapter(IStoreObject[].class);
                                if (storeObjects != null) break block21;
                                IStoreObject object = (IStoreObject)adaptable.getAdapter(IStoreObject.class);
                                if (object == null) break block22;
                                storeObjects = new IStoreObject[]{object};
                            }
                            ArrayList<IStoreObject> childStoreObjects = new ArrayList<IStoreObject>();
                            if (adaptable instanceof ISecurity && (history = RepositoryService.this.getHistoryFor((ISecurity)adaptable)) != null) {
                                IStoreObject[] subsetStoreObject;
                                Date last;
                                Date first;
                                IHistory historySubset;
                                IOHLC[] ohlc;
                                IStoreObject historyStoreObject = (IStoreObject)history.getAdapter(IStoreObject.class);
                                if (historyStoreObject != null && historyStoreObject.getStore() != null) {
                                    childStoreObjects.add(historyStoreObject);
                                }
                                if ((ohlc = history.getOHLC()) != null && ohlc.length != 0 && (historySubset = history.getSubset(first = ohlc[0].getDate(), last = ohlc[ohlc.length - 1].getDate(), TimeSpan.minutes(1))) != null && (subsetStoreObject = (IStoreObject[])historySubset.getAdapter(IStoreObject[].class)) != null) {
                                    childStoreObjects.addAll(Arrays.asList(subsetStoreObject));
                                }
                            }
                            IStoreObject[] iStoreObjectArray = storeObjects;
                            int n3 = storeObjects.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IStoreObject object = iStoreObjectArray[n4];
                                final IStore oldStore = object.getStore();
                                if (oldStore == null || oldStore.getRepository() != destination) {
                                    IStatus status;
                                    IStoreProperties properties = object.getStoreProperties();
                                    IStore newStore = destination.createObject();
                                    newStore.putProperties(properties, monitor);
                                    object.setStore(newStore);
                                    for (IStoreObject childObject : childStoreObjects) {
                                        final IStore oldChildStore = childObject.getStore();
                                        if (oldChildStore != null && oldChildStore.getRepository() == destination) continue;
                                        IStoreProperties childProperties = childObject.getStoreProperties();
                                        IStore newChildStore = destination.createObject();
                                        newChildStore.putProperties(childProperties, monitor);
                                        childObject.setStore(newStore);
                                        IStatus status2 = oldChildStore.getRepository().runInRepository(new IRepositoryRunnable(){

                                            @Override
                                            public IStatus run(IProgressMonitor monitor) throws Exception {
                                                oldChildStore.delete(monitor);
                                                return Status.OK_STATUS;
                                            }
                                        }, monitor);
                                        if (status2 == Status.OK_STATUS) continue;
                                        return status2;
                                    }
                                    if (oldStore != null && (status = oldStore.getRepository().runInRepository(new IRepositoryRunnable(){

                                        @Override
                                        public IStatus run(IProgressMonitor monitor) throws Exception {
                                            oldStore.delete(monitor);
                                            return Status.OK_STATUS;
                                        }
                                    }, monitor)) != Status.OK_STATUS) {
                                        return status;
                                    }
                                    if (adaptable instanceof ISecurity) {
                                        if (oldStore != null) {
                                            RepositoryService.this.uriMap.remove(oldStore.toURI());
                                        }
                                        RepositoryService.this.uriMap.put(newStore.toURI(), (ISecurity)adaptable);
                                        RepositoryService.this.nameMap.put(((ISecurity)adaptable).getName(), (ISecurity)adaptable);
                                        for (IWatchList watchList : RepositoryService.this.watchlistUriMap.values()) {
                                            if (watchList.getItem((ISecurity)adaptable) == null) continue;
                                            IStoreObject otherObject = (IStoreObject)watchList.getAdapter(IStoreObject.class);
                                            IStoreProperties otherProperties = otherObject.getStoreProperties();
                                            otherObject.getStore().putProperties(otherProperties, monitor);
                                        }
                                    }
                                    if (adaptable instanceof IWatchList) {
                                        if (oldStore != null) {
                                            RepositoryService.this.watchlistUriMap.remove(oldStore.toURI());
                                        }
                                        RepositoryService.this.watchlistUriMap.put(newStore.toURI(), (IWatchList)adaptable);
                                        RepositoryService.this.watchlistNameMap.put(((IWatchList)adaptable).getName(), (IWatchList)adaptable);
                                    }
                                    if (RepositoryService.this.deltas != null) {
                                        int kind = 8192;
                                        kind = oldStore != null ? (kind |= 0x1000) : (kind |= 1);
                                        RepositoryService.this.deltas.add(new RepositoryResourceDelta(kind, adaptable, oldStore != null ? oldStore.getRepository() : null, newStore.getRepository(), null, null));
                                    }
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    Status status = new Status(4, "org.eclipsetrader.core", 0, "Error moving object", (Throwable)e);
                    CoreActivator.getDefault().getLog().log((IStatus)status);
                    return status;
                }
                catch (LinkageError e) {
                    Status status = new Status(4, "org.eclipsetrader.core", 0, "Error moving object", (Throwable)e);
                    CoreActivator.getDefault().getLog().log((IStatus)status);
                    return status;
                }
                return Status.OK_STATUS;
            }
        }, (ISchedulingRule)new MultiRule(rules.toArray(new ISchedulingRule[rules.size()])), null);
    }

    @Override
    public IFeedIdentifier getFeedIdentifierFromSymbol(String symbol) {
        return this.identifiersMap.get(symbol);
    }

    @Override
    public IFeedIdentifier[] getFeedIdentifiers() {
        Collection<IFeedIdentifier> c = this.identifiersMap.values();
        return c.toArray(new IFeedIdentifier[c.size()]);
    }

    public void startUp() {
        IRepository[] repository;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipsetrader.core.repositories");
        if (extensionPoint == null) {
            return;
        }
        IConfigurationElement[] configElements = extensionPoint.getConfigurationElements();
        int j = 0;
        while (j < configElements.length) {
            if ("repository".equals(configElements[j].getName())) {
                Status status;
                String id = configElements[j].getAttribute("id");
                String schema = configElements[j].getAttribute("scheme");
                try {
                    repository = (IRepository[])configElements[j].createExecutableExtension("class");
                    this.repositoryMap.put(schema, (IRepository)repository);
                }
                catch (Exception e) {
                    status = new Status(4, "org.eclipsetrader.core", 0, "Unable to create repository with id " + id, (Throwable)e);
                    CoreActivator.log((IStatus)status);
                }
                catch (LinkageError e) {
                    status = new Status(4, "org.eclipsetrader.core", 0, "Unable to create repository with id " + id, (Throwable)e);
                    CoreActivator.log((IStatus)status);
                }
            }
            ++j;
        }
        j = 0;
        while (j < configElements.length) {
            if ("provider".equals(configElements[j].getName())) {
                Status status;
                String clazz = configElements[j].getAttribute("class");
                try {
                    IRepositoryProvider provider = (IRepositoryProvider)configElements[j].createExecutableExtension("class");
                    repository = provider.getRepositories((IProgressMonitor)new NullProgressMonitor());
                    int i = 0;
                    while (i < repository.length) {
                        this.repositoryMap.put(repository[i].getSchema(), repository[i]);
                        ++i;
                    }
                }
                catch (Exception e) {
                    status = new Status(4, "org.eclipsetrader.core", 0, "Unable to instantiate repository provider " + clazz, (Throwable)e);
                    CoreActivator.log((IStatus)status);
                }
                catch (LinkageError e) {
                    status = new Status(4, "org.eclipsetrader.core", 0, "Unable to instantiate repository provider " + clazz, (Throwable)e);
                    CoreActivator.log((IStatus)status);
                }
            }
            ++j;
        }
        for (IRepository repository2 : this.repositoryMap.values()) {
            IStore[] iStoreArray = repository2.fetchObjects(null);
            int n = iStoreArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStore store = iStoreArray[n2];
                if (!this.uriMap.containsKey(store.toURI()) && !this.watchlistUriMap.containsKey(store.toURI())) {
                    IStoreObject element = this.createElement(store, store.fetchProperties(null));
                    if (element instanceof ISecurity) {
                        this.putSecurity(store, (ISecurity)((Object)element));
                    } else if (element instanceof IWatchList) {
                        this.putWatchList(store, (IWatchList)((Object)element));
                    } else if (element instanceof IHolding) {
                        this.trades.add((IHolding)((Object)element));
                    }
                }
                ++n2;
            }
        }
    }

    public void shutDown() {
    }

    protected void putSecurity(IStore store, ISecurity security) {
        this.uriMap.put(store.toURI(), security);
        this.nameMap.put(security.getName(), security);
        IFeedIdentifier identifier = security.getIdentifier();
        if (identifier != null) {
            this.identifiersMap.put(identifier.getSymbol(), identifier);
        }
    }

    protected void putWatchList(IStore store, IWatchList watchlist) {
        this.watchlistUriMap.put(store.toURI(), watchlist);
        this.watchlistNameMap.put(watchlist.getName(), watchlist);
    }

    protected IStoreObject createElement(IStore store, IStoreProperties properties) {
        try {
            IRepositoryElementFactory factory = (IRepositoryElementFactory)properties.getProperty("factory");
            if (factory != null) {
                return factory.createElement(store, properties);
            }
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipsetrader.core", 0, "Error creating element " + store.toURI().toString(), (Throwable)e);
            CoreActivator.getDefault().getLog().log((IStatus)status);
        }
        catch (LinkageError e) {
            Status status = new Status(4, "org.eclipsetrader.core", 0, "Error creating element " + store.toURI().toString(), (Throwable)e);
            CoreActivator.getDefault().getLog().log((IStatus)status);
        }
        return DefaultElementFactory.getInstance().createElement(store, properties);
    }

    @Override
    public IStatus runInService(IRepositoryRunnable runnable, IProgressMonitor monitor) {
        return this.runInService(runnable, null, monitor);
    }

    @Override
    public IStatus runInService(IRepositoryRunnable runnable, ISchedulingRule rule, IProgressMonitor monitor) {
        Status status;
        if (rule != null) {
            this.jobManager.beginRule(rule, monitor);
        }
        try {
            try {
                this.lock.acquire();
                this.deltas = new ArrayList<RepositoryResourceDelta>();
                try {
                    status = runnable.run(monitor);
                }
                catch (Exception e) {
                    status = new Status(4, "org.eclipsetrader.core", 0, "Error running service task", (Throwable)e);
                    CoreActivator.getDefault().getLog().log((IStatus)status);
                }
                catch (LinkageError e) {
                    status = new Status(4, "org.eclipsetrader.core", 0, "Error running service task", (Throwable)e);
                    CoreActivator.getDefault().getLog().log((IStatus)status);
                }
                if (this.deltas.size() != 0) {
                    final RepositoryChangeEvent event = new RepositoryChangeEvent(this.getDeltas());
                    Object[] l = this.listeners.getListeners();
                    int i = 0;
                    while (i < l.length) {
                        final IRepositoryChangeListener listener = (IRepositoryChangeListener)l[i];
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void run() throws Exception {
                                listener.repositoryResourceChanged(event);
                            }

                            public void handleException(Throwable exception) {
                                Status status = new Status(4, "org.eclipsetrader.core", 0, "Error running repository listener", exception);
                                CoreActivator.getDefault().getLog().log((IStatus)status);
                            }
                        });
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                status = new Status(4, "org.eclipsetrader.core", 0, "Error running repository task", (Throwable)e);
                CoreActivator.getDefault().getLog().log((IStatus)status);
                this.lock.release();
                if (rule != null) {
                    this.jobManager.endRule(rule);
                }
            }
        }
        finally {
            this.lock.release();
            if (rule != null) {
                this.jobManager.endRule(rule);
            }
        }
        return status;
    }

    public boolean contains(ISchedulingRule rule) {
        if (this == rule) {
            return true;
        }
        if (rule instanceof MultiRule) {
            MultiRule multi = (MultiRule)rule;
            ISchedulingRule[] children = multi.getChildren();
            int i = 0;
            while (i < children.length) {
                if (!this.contains(children[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return this == rule;
    }

    @Override
    public void addRepositoryResourceListener(IRepositoryChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeRepositoryResourceListener(IRepositoryChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected RepositoryResourceDelta[] getDeltas() {
        if (this.deltas == null) {
            return new RepositoryResourceDelta[0];
        }
        return this.deltas.toArray(new RepositoryResourceDelta[this.deltas.size()]);
    }

    @Override
    public IStoreObject getObjectFromURI(URI uri) {
        IStore store;
        String schema = uri.getScheme();
        IRepository repository = this.getRepository(schema);
        if (repository != null && (store = repository.getObject(uri)) != null) {
            IStoreObject element = this.objectsMap.get(store.toURI());
            if (element == null && (element = this.createElement(store, store.fetchProperties(null))) != null) {
                this.objectsMap.put(store.toURI(), element);
            }
            return element;
        }
        return null;
    }

    @Override
    public IStoreObject[] getAllObjects() {
        ArrayList<IStoreObject> result = new ArrayList<IStoreObject>();
        IRepository[] iRepositoryArray = this.getRepositories();
        int n = iRepositoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStore[] objects;
            IRepository repository = iRepositoryArray[n2];
            IStore[] iStoreArray = objects = repository.fetchObjects((IProgressMonitor)new NullProgressMonitor());
            int n3 = objects.length;
            int n4 = 0;
            while (n4 < n3) {
                IStore store = iStoreArray[n4];
                IStoreObject element = this.objectsMap.get(store.toURI());
                if (element == null && (element = this.createElement(store, store.fetchProperties(null))) != null) {
                    this.objectsMap.put(store.toURI(), element);
                }
                if (element != null) {
                    result.add(element);
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new IStoreObject[result.size()]);
    }
}

