/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.trading;

import java.util.Date;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.feed.IBackfillConnector;
import org.eclipsetrader.core.feed.IFeedConnector;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.markets.IMarket;
import org.eclipsetrader.core.markets.IMarketDay;
import org.eclipsetrader.core.markets.IMarketService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class MarketAdapter
extends XmlAdapter<String, IMarket> {
    public String marshal(IMarket v) throws Exception {
        return v != null ? v.getName() : null;
    }

    public IMarket unmarshal(String v) throws Exception {
        if (v == null) {
            return null;
        }
        IMarket market = null;
        try {
            BundleContext context = CoreActivator.getDefault().getBundle().getBundleContext();
            ServiceReference serviceReference = context.getServiceReference(IMarketService.class.getName());
            IMarketService marketService = (IMarketService)context.getService(serviceReference);
            market = marketService.getMarket(v);
            context.ungetService(serviceReference);
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipsetrader.core", 0, "Error reading market service", (Throwable)e);
            CoreActivator.log((IStatus)status);
        }
        if (market == null) {
            Status status = new Status(2, "org.eclipsetrader.core", 0, "Failed to load market " + v, null);
            CoreActivator.log((IStatus)status);
            return new FailsafeMarket(v);
        }
        return market;
    }

    private class FailsafeMarket
    implements IMarket {
        private String name;

        public FailsafeMarket(String name) {
            this.name = name;
        }

        @Override
        public void addMembers(ISecurity[] securities) {
        }

        @Override
        public IBackfillConnector getBackfillConnector() {
            return null;
        }

        @Override
        public IBackfillConnector getIntradayBackfillConnector() {
            return null;
        }

        @Override
        public IFeedConnector getLiveFeedConnector() {
            return null;
        }

        @Override
        public ISecurity[] getMembers() {
            return null;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public IMarketDay getNextDay() {
            return null;
        }

        @Override
        public IMarketDay getToday() {
            return null;
        }

        @Override
        public boolean hasMember(ISecurity security) {
            return false;
        }

        @Override
        public boolean isOpen() {
            return false;
        }

        @Override
        public boolean isOpen(Date time) {
            return false;
        }

        @Override
        public void removeMembers(ISecurity[] securities) {
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }
}

