/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.trading;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.internal.trading.MarketBroker;
import org.eclipsetrader.core.markets.IMarket;
import org.eclipsetrader.core.trading.IBroker;

public class MarketBrokerAdapterFactory
implements IAdapterFactory {
    private File file;
    private List<MarketBroker> list;

    public MarketBrokerAdapterFactory(File file) {
        this.file = file;
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (this.list == null) {
            this.list = new ArrayList<MarketBroker>();
            try {
                if (this.file.exists()) {
                    this.load(this.file);
                }
            }
            catch (Exception exception) {
                Status status = new Status(4, "org.eclipsetrader.core", 0, "Error loading market brokers settings", null);
                CoreActivator.getDefault().getLog().log((IStatus)status);
            }
        }
        if (!(adaptableObject instanceof IMarket)) {
            return null;
        }
        if (adapterType.isAssignableFrom(this.getClass())) {
            return this;
        }
        if (adapterType.isAssignableFrom(IBroker.class)) {
            for (MarketBroker broker : this.list) {
                if (broker.getMarket() != adaptableObject) continue;
                return broker.getConnector();
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IBroker.class, MarketBrokerAdapterFactory.class};
    }

    void load(File file) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MarketBroker[].class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                Status status = new Status(2, "org.eclipsetrader.core", 0, "Error validating XML: " + event.getMessage(), null);
                CoreActivator.log((IStatus)status);
                return true;
            }
        });
        JAXBElement element = unmarshaller.unmarshal((Source)new StreamSource(file), MarketBroker[].class);
        this.list.addAll(Arrays.asList((MarketBroker[])element.getValue()));
    }

    public void addOverride(MarketBroker override) {
        Iterator<MarketBroker> iter = this.list.iterator();
        while (iter.hasNext()) {
            if (iter.next().getMarket() != override.getMarket()) continue;
            iter.remove();
        }
        this.list.add(override);
    }

    public void removeOverride(MarketBroker override) {
        Iterator<MarketBroker> iter = this.list.iterator();
        while (iter.hasNext()) {
            if (iter.next().getMarket() != override.getMarket()) continue;
            iter.remove();
        }
    }

    public void clearOverride(IMarket market) {
        Iterator<MarketBroker> iter = this.list.iterator();
        while (iter.hasNext()) {
            if (iter.next().getMarket() != market) continue;
            iter.remove();
        }
    }

    public void save(File file) throws JAXBException, IOException {
        if (this.list == null) {
            return;
        }
        if (file.exists()) {
            file.delete();
        }
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MarketBroker[].class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                Status status = new Status(2, "org.eclipsetrader.core", 0, "Error validating XML: " + event.getMessage(), null);
                CoreActivator.log((IStatus)status);
                return true;
            }
        });
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.encoding", (Object)System.getProperty("file.encoding"));
        JAXBElement element = new JAXBElement(new QName("list"), MarketBroker[].class, (Object)this.list.toArray(new MarketBroker[this.list.size()]));
        marshaller.marshal((Object)element, (Writer)new FileWriter(file));
    }
}

