/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.trading;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.osgi.util.NLS;
import org.eclipsetrader.core.feed.IQuote;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.internal.trading.Messages;
import org.eclipsetrader.core.trading.IAlert;

public class TargetPrice
implements IExecutableExtension,
IAlert,
IAdaptable {
    public static final String PLUGIN_ID = "org.eclipsetrader.core.trading.alerts.targetprice";
    public static final int F_LAST = 0;
    public static final int F_BID = 1;
    public static final int F_ASK = 2;
    public static final String K_FIELD = "field";
    public static final String K_PRICE = "price";
    public static final String K_CROSS = "cross";
    private String id = "org.eclipsetrader.core.trading.alerts.targetprice";
    private String name = "Target Price";
    int field;
    double price;
    boolean cross;
    String description;
    double initialPrice;
    boolean triggered;

    public static String getDescriptionFor(Map<String, Object> map) {
        int field = (Integer)map.get(K_FIELD);
        double price = (Double)map.get(K_PRICE);
        boolean cross = (Boolean)map.get(K_CROSS);
        return NLS.bind((String)Messages.TargetPrice_Price, (Object[])new Object[]{field == 0 ? Messages.TargetPrice_Last : (field == 1 ? Messages.TargetPrice_Bid : Messages.TargetPrice_Ask), cross ? Messages.TargetPrice_Crosses : Messages.TargetPrice_Reaches, NumberFormat.getInstance().format(price)});
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.id = config.getAttribute("id");
        this.name = config.getAttribute("name");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setParameters(Map<String, Object> map) {
        this.field = (Integer)map.get(K_FIELD);
        this.price = (Double)map.get(K_PRICE);
        this.cross = (Boolean)map.get(K_CROSS);
        this.description = TargetPrice.getDescriptionFor(map);
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(K_FIELD, this.field);
        map.put(K_PRICE, this.price);
        map.put(K_CROSS, this.cross);
        return map;
    }

    @Override
    public void setInitialValues(ITrade trade, IQuote quote) {
        switch (this.field) {
            case 0: {
                if (trade == null || trade.getPrice() == null) {
                    return;
                }
                this.initialPrice = trade.getPrice();
                break;
            }
            case 1: {
                if (quote == null || quote.getBid() == null) {
                    return;
                }
                this.initialPrice = quote.getBid();
                break;
            }
            case 2: {
                if (quote == null || quote.getAsk() == null) {
                    return;
                }
                this.initialPrice = quote.getAsk();
            }
        }
        this.triggered = false;
    }

    @Override
    public void setTrade(ITrade trade) {
        if (this.field != 0) {
            return;
        }
        if (trade == null || trade.getPrice() == null) {
            return;
        }
        this.updateTrigger(trade.getPrice());
    }

    @Override
    public void setQuote(IQuote quote) {
        if (this.field != 0 && this.field != 1) {
            return;
        }
        if (quote == null) {
            return;
        }
        if (this.field == 1) {
            if (quote.getBid() == null) {
                return;
            }
            this.updateTrigger(quote.getBid());
        } else if (this.field == 2) {
            if (quote.getAsk() == null) {
                return;
            }
            this.updateTrigger(quote.getAsk());
        }
    }

    void updateTrigger(double value) {
        if (this.initialPrice == 0.0) {
            this.initialPrice = value;
        }
        if (this.cross) {
            if (this.price > this.initialPrice) {
                boolean bl = this.triggered = value > this.initialPrice && value > this.price;
            }
            if (this.price < this.initialPrice) {
                this.triggered = value < this.initialPrice && value < this.price;
            }
        } else {
            if (this.price > this.initialPrice) {
                boolean bl = this.triggered = value > this.initialPrice && value >= this.price;
            }
            if (this.price < this.initialPrice) {
                this.triggered = value < this.initialPrice && value <= this.price;
            }
        }
    }

    @Override
    public boolean isTriggered() {
        return this.triggered;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }
}

