/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.trading;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.markets.IMarket;
import org.eclipsetrader.core.markets.IMarketService;
import org.eclipsetrader.core.trading.IBroker;
import org.eclipsetrader.core.trading.IOrderChangeListener;
import org.eclipsetrader.core.trading.IOrderMonitor;
import org.eclipsetrader.core.trading.IPositionListener;
import org.eclipsetrader.core.trading.ITradingService;
import org.eclipsetrader.core.trading.OrderChangeEvent;
import org.eclipsetrader.core.trading.OrderDelta;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class TradingService
implements ITradingService {
    private Map<String, IBroker> brokers = new HashMap<String, IBroker>();
    private Set<IOrderMonitor> orders = new HashSet<IOrderMonitor>();
    private ListenerList listeners = new ListenerList(1);
    private ListenerList positionListeners = new ListenerList(1);
    private IOrderChangeListener orderChangeListener = new IOrderChangeListener(){

        @Override
        public void orderChanged(OrderChangeEvent event) {
            TradingService.this.processOrderChangedEvent(event);
            TradingService.this.fireUpdateNotifications(event.broker, event.deltas);
        }
    };

    public void startUp() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipsetrader.core.trading.brokers");
        if (extensionPoint != null) {
            IConfigurationElement[] configElements = extensionPoint.getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                try {
                    IBroker connector = (IBroker)configElements[j].createExecutableExtension("class");
                    this.brokers.put(connector.getId(), connector);
                }
                catch (CoreException e) {
                    Status status = new Status(4, "org.eclipsetrader.core", 0, "Error creating broker instance with id " + configElements[j].getAttribute("id"), (Throwable)e);
                    CoreActivator.log((IStatus)status);
                }
                ++j;
            }
        }
        for (IBroker connector : this.brokers.values()) {
            IOrderMonitor[] o = connector.getOrders();
            if (o != null) {
                this.orders.addAll(Arrays.asList(o));
            }
            connector.addOrderChangeListener(this.orderChangeListener);
        }
    }

    public void shutDown() {
        for (IBroker connector : this.brokers.values()) {
            connector.removeOrderChangeListener(this.orderChangeListener);
            connector.disconnect();
        }
    }

    @Override
    public IBroker[] getBrokers() {
        Collection<IBroker> c = this.brokers.values();
        return c.toArray(new IBroker[c.size()]);
    }

    @Override
    public IBroker getBroker(String id) {
        return this.brokers.get(id);
    }

    @Override
    public IBroker getBrokerForSecurity(ISecurity security) {
        IBroker broker = null;
        try {
            BundleContext context = CoreActivator.getDefault().getBundle().getBundleContext();
            ServiceReference serviceReference = context.getServiceReference(IMarketService.class.getName());
            if (serviceReference != null) {
                IMarketService service = (IMarketService)context.getService(serviceReference);
                IMarket market = service.getMarketForSecurity(security);
                if (market != null) {
                    broker = (IBroker)market.getAdapter(IBroker.class);
                }
                context.ungetService(serviceReference);
            }
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipsetrader.core", 0, "Error reading market service", (Throwable)e);
            CoreActivator.getDefault().getLog().log((IStatus)status);
        }
        if (broker == null) {
            for (IBroker connector : this.brokers.values()) {
                if (!connector.canTrade(security)) continue;
                return connector;
            }
        }
        return broker;
    }

    @Override
    public IOrderMonitor[] getOrders() {
        return this.orders.toArray(new IOrderMonitor[this.orders.size()]);
    }

    @Override
    public void addOrderChangeListener(IOrderChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeOrderChangeListener(IOrderChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void processOrderChangedEvent(OrderChangeEvent event) {
        OrderDelta[] orderDeltaArray = event.deltas;
        int n = event.deltas.length;
        int n2 = 0;
        while (n2 < n) {
            OrderDelta delta = orderDeltaArray[n2];
            if (delta.getKind() == 1) {
                this.orders.add(delta.getOrder());
            } else if (delta.getKind() == 2) {
                this.orders.remove(delta.getOrder());
            } else if (!this.orders.contains(delta.getOrder())) {
                this.orders.add(delta.getOrder());
            }
            ++n2;
        }
    }

    protected void fireUpdateNotifications(IBroker broker, OrderDelta[] deltas) {
        if (deltas.length != 0) {
            OrderChangeEvent event = new OrderChangeEvent(broker, deltas);
            Object[] l = this.listeners.getListeners();
            int i = 0;
            while (i < l.length) {
                try {
                    ((IOrderChangeListener)l[i]).orderChanged(event);
                }
                catch (Throwable e) {
                    Status status = new Status(4, "org.eclipsetrader.core", 0, "Error running listener", e);
                    CoreActivator.log((IStatus)status);
                }
                ++i;
            }
        }
    }

    @Override
    public void addPositionListener(IPositionListener listener) {
        this.positionListeners.add((Object)listener);
    }

    @Override
    public void removePositionListener(IPositionListener listener) {
        this.positionListeners.remove((Object)listener);
    }
}

