/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.trading;

import java.util.Date;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.trading.IAccount;
import org.eclipsetrader.core.trading.IOrder;
import org.eclipsetrader.core.trading.IOrderRoute;
import org.eclipsetrader.core.trading.IOrderSide;
import org.eclipsetrader.core.trading.IOrderType;
import org.eclipsetrader.core.trading.IOrderValidity;

public class Order
implements IOrder {
    private Date date;
    private IOrderRoute route;
    private IAccount account;
    private ISecurity security;
    private Long quantity;
    private Double price;
    private Double stopPrice;
    private IOrderType type;
    private IOrderSide side;
    private IOrderValidity validity;
    private Date expireDate;
    private String reference;

    protected Order() {
    }

    public Order(IAccount account, IOrderType type, IOrderSide side, ISecurity security, Long quantity, Double price) {
        this.account = account;
        this.type = type;
        this.side = side;
        this.security = security;
        this.quantity = quantity;
        this.price = price;
        this.date = new Date();
    }

    public Order(IAccount account, IOrderType type, IOrderSide side, ISecurity security, Long quantity, Double price, IOrderRoute route) {
        this.account = account;
        this.type = type;
        this.side = side;
        this.security = security;
        this.quantity = quantity;
        this.price = price;
        this.route = route;
        this.date = new Date();
    }

    public Order(IAccount account, IOrderSide side, ISecurity security, Long quantity) {
        this.account = account;
        this.type = IOrderType.Market;
        this.side = side;
        this.security = security;
        this.quantity = quantity;
        this.date = new Date();
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public IOrderRoute getRoute() {
        return this.route;
    }

    public void setRoute(IOrderRoute route) {
        this.route = route;
    }

    @Override
    public IAccount getAccount() {
        return this.account;
    }

    @Override
    public ISecurity getSecurity() {
        return this.security;
    }

    @Override
    public Long getQuantity() {
        return this.quantity;
    }

    @Override
    public Double getPrice() {
        return this.price;
    }

    @Override
    public IOrderSide getSide() {
        return this.side;
    }

    @Override
    public IOrderType getType() {
        return this.type;
    }

    @Override
    public Double getStopPrice() {
        return this.stopPrice;
    }

    @Override
    public IOrderValidity getValidity() {
        return this.validity;
    }

    public void setValidity(IOrderValidity validity) {
        this.validity = validity;
    }

    @Override
    public Date getExpire() {
        return this.expireDate;
    }

    public void setExpire(Date expireDate) {
        this.expireDate = expireDate;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Order: date=" + this.getDate() + ", instrument=" + this.getSecurity().getName() + ", type=" + this.getType() + ", side=" + this.getSide() + ", quantity=" + this.getQuantity());
        if (this.getPrice() != null) {
            sb.append(", price=" + this.getPrice());
        }
        if (this.getStopPrice() != null) {
            sb.append(", stopPrice=" + this.getStopPrice());
        }
        if (this.getValidity() != null) {
            sb.append(", timeInForce=" + this.getValidity());
        }
        if (this.getExpire() != null) {
            sb.append(", expiration=" + this.getExpire());
        }
        if (this.getReference() != null) {
            sb.append(", reference=" + this.getReference());
        }
        return sb.toString();
    }
}

