/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.views;

import java.beans.PropertyChangeSupport;
import java.util.Date;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.repositories.IStore;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.eclipsetrader.core.repositories.IStoreProperties;
import org.eclipsetrader.core.repositories.StoreProperties;
import org.eclipsetrader.core.views.IHolding;

public class Holding
implements IHolding,
IStoreObject {
    public static final String PROP_QUANTITY = "position";
    public static final String PROP_PRICE = "purchasePrice";
    private ISecurity security;
    private Long position;
    private Double purchasePrice;
    private Date date;
    private IStore store;
    private IStoreProperties storeProperties;
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    protected Holding() {
    }

    public Holding(ISecurity security) {
        this(security, null, null, null);
    }

    public Holding(ISecurity security, Long position, Double purchasePrice) {
        this(security, position, purchasePrice, null);
    }

    public Holding(ISecurity security, Long position, Double purchasePrice, Date date) {
        this.security = security;
        this.position = position;
        this.purchasePrice = purchasePrice;
        this.date = date;
    }

    public Holding(IStore store, IStoreProperties storeProperties) {
        this.setStore(store);
        this.setStoreProperties(storeProperties);
    }

    @Override
    public ISecurity getSecurity() {
        return this.security;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public Long getPosition() {
        return this.position;
    }

    public void setPosition(Long position) {
        this.position = position;
        this.changeSupport.firePropertyChange(PROP_QUANTITY, this.position, this.position);
    }

    @Override
    public Double getPurchasePrice() {
        return this.purchasePrice;
    }

    public void setPurchasePrice(Double purchasePrice) {
        this.purchasePrice = purchasePrice;
        this.changeSupport.firePropertyChange(PROP_PRICE, this.purchasePrice, this.purchasePrice);
    }

    public Object getAdapter(Class adapter) {
        if (this.security != null) {
            if (this.security.getIdentifier() != null && adapter.isAssignableFrom(this.security.getIdentifier().getClass())) {
                return this.security;
            }
            if (adapter.isAssignableFrom(this.security.getClass())) {
                return this.security;
            }
        }
        if (adapter.isAssignableFrom(this.changeSupport.getClass())) {
            return this.changeSupport;
        }
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    @Override
    public IStore getStore() {
        return this.store;
    }

    @Override
    public void setStore(IStore store) {
        this.store = store;
    }

    @Override
    public IStoreProperties getStoreProperties() {
        if (this.storeProperties == null) {
            this.storeProperties = new StoreProperties();
        }
        this.storeProperties.setProperty("type", IHolding.class.getName());
        this.storeProperties.setProperty("purchase-date", this.date);
        this.storeProperties.setProperty("security", this.security);
        this.storeProperties.setProperty("purchase-date", this.security);
        this.storeProperties.setProperty("purchase-quantity", this.position);
        this.storeProperties.setProperty("purchase-price", this.purchasePrice);
        return this.storeProperties;
    }

    @Override
    public void setStoreProperties(IStoreProperties storeProperties) {
        this.storeProperties = storeProperties;
        this.date = (Date)storeProperties.getProperty("purchase-date");
        this.security = (ISecurity)storeProperties.getProperty("security");
        this.position = (Long)storeProperties.getProperty("purchase-quantity");
        this.purchasePrice = (Double)storeProperties.getProperty("purchase-price");
    }
}

