/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipsetrader.core.views.IViewItem;

public class ViewItemDelta {
    public static final int NO_CHANGE = 0;
    public static final int ADDED = 1;
    public static final int REMOVED = 2;
    public static final int CHANGED = 4;
    private int kind = 0;
    private IViewItem viewItem;
    private IAdaptable[] oldValues;
    private IAdaptable[] newValues;
    private List<ViewItemDelta> childs = new ArrayList<ViewItemDelta>();

    protected ViewItemDelta() {
    }

    public ViewItemDelta(int kind, IViewItem viewItem) {
        this.kind = kind;
        this.viewItem = viewItem;
    }

    public ViewItemDelta(int kind, IViewItem viewItem, IAdaptable[] oldValues, IAdaptable[] newValues) {
        this.kind = kind;
        this.viewItem = viewItem;
        this.oldValues = oldValues;
        this.newValues = newValues;
    }

    public int getKind() {
        return this.kind;
    }

    public IViewItem getViewItem() {
        return this.viewItem;
    }

    public int getChildCount() {
        return this.childs.size();
    }

    public ViewItemDelta[] getChilds() {
        return this.childs.toArray(new ViewItemDelta[this.childs.size()]);
    }

    public ViewItemDelta createChild(IViewItem viewItem, int kind) {
        ViewItemDelta delta = new ViewItemDelta(kind, viewItem);
        this.childs.add(delta);
        return delta;
    }

    public ViewItemDelta createChild(int kind, IViewItem viewItem, IAdaptable[] oldValues, IAdaptable[] newValues) {
        ViewItemDelta delta = new ViewItemDelta(kind, viewItem, oldValues, newValues);
        this.childs.add(delta);
        return delta;
    }

    public IAdaptable[] getOldValues() {
        return this.oldValues;
    }

    public IAdaptable[] getNewValues() {
        return this.newValues;
    }
}

