/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.views;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Date;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.views.IHolding;
import org.eclipsetrader.core.views.IWatchListElement;

public class WatchListElement
implements IWatchListElement {
    private ISecurity security;
    private Long position;
    private Double purchasePrice;
    private Date date;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    protected WatchListElement() {
    }

    public WatchListElement(ISecurity security) {
        this(security, null, null, null);
    }

    public WatchListElement(ISecurity security, Long position, Double purchasePrice) {
        this(security, position, purchasePrice, null);
    }

    public WatchListElement(ISecurity security, Long position, Double purchasePrice, Date date) {
        this.security = security;
        this.position = position;
        this.purchasePrice = purchasePrice;
        this.date = date;
    }

    public WatchListElement(IHolding holding) {
        this(holding.getSecurity(), holding.getPosition(), holding.getPurchasePrice(), holding.getDate());
    }

    @Override
    public ISecurity getSecurity() {
        return this.security;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public void setDate(Date date) {
        Date oldValue = this.date;
        this.date = date;
        this.propertyChangeSupport.firePropertyChange("date", oldValue, this.date);
    }

    @Override
    public Long getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Long position) {
        Long oldValue = this.position;
        this.position = position;
        this.propertyChangeSupport.firePropertyChange("position", oldValue, this.position);
    }

    @Override
    public Double getPurchasePrice() {
        return this.purchasePrice;
    }

    @Override
    public void setPurchasePrice(Double purchasePrice) {
        Double oldValue = this.purchasePrice;
        this.purchasePrice = purchasePrice;
        this.propertyChangeSupport.firePropertyChange("purchasePrice", oldValue, this.purchasePrice);
    }

    public Object getAdapter(Class adapter) {
        Object obj;
        if (adapter.isAssignableFrom(PropertyChangeSupport.class)) {
            return this.propertyChangeSupport;
        }
        if (this.security != null && (obj = this.security.getAdapter(adapter)) != null) {
            return obj;
        }
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }
}

