/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.news.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipsetrader.core.ILauncher;
import org.eclipsetrader.news.core.HeadLineStatus;
import org.eclipsetrader.news.core.INewsProvider;
import org.eclipsetrader.news.core.INewsServiceListener;
import org.eclipsetrader.news.core.NewsEvent;
import org.eclipsetrader.news.internal.Activator;
import org.eclipsetrader.news.internal.HeadLineCountNotification;
import org.eclipsetrader.news.internal.NewsService;
import org.eclipsetrader.ui.INotification;
import org.eclipsetrader.ui.INotificationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class NewsServiceLauncher
implements ILauncher,
IExecutableExtension {
    private String id;
    private String name;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.id = config.getAttribute("id");
        this.name = config.getAttribute("name");
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void launch(IProgressMonitor monitor) {
        try {
            BundleContext context = Activator.getDefault().getBundle().getBundleContext();
            ServiceReference serviceReference = context.getServiceReference(NewsService.class);
            if (serviceReference != null) {
                NewsService newsService = (NewsService)context.getService(serviceReference);
                newsService.addNewsServiceListener(new INewsServiceListener(){

                    @Override
                    public void newsServiceUpdate(NewsEvent event) {
                        int count = 0;
                        HeadLineStatus[] headLineStatusArray = event.getStatus();
                        int n = headLineStatusArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            HeadLineStatus status = headLineStatusArray[n2];
                            if (status.getKind() == 1) {
                                ++count;
                            }
                            ++n2;
                        }
                        if (count != 0) {
                            try {
                                BundleContext context = Activator.getDefault().getBundle().getBundleContext();
                                ServiceReference serviceReference = context.getServiceReference(INotificationService.class);
                                if (serviceReference != null) {
                                    INotificationService notificationService = (INotificationService)context.getService(serviceReference);
                                    notificationService.popupNotification(new INotification[]{new HeadLineCountNotification(count)});
                                }
                                context.ungetService(serviceReference);
                            }
                            catch (Exception e) {
                                Status status = new Status(4, "org.eclipsetrader.news", 0, "Error reading news service", (Throwable)e);
                                Activator.getDefault().getLog().log((IStatus)status);
                            }
                        }
                    }
                });
                IPreferenceStore store = Activator.getDefault().getPreferenceStore();
                INewsProvider[] iNewsProviderArray = newsService.getProviders();
                int n = iNewsProviderArray.length;
                int n2 = 0;
                while (n2 < n) {
                    INewsProvider newsProvider = iNewsProviderArray[n2];
                    if (store.getBoolean(newsProvider.getId())) {
                        newsProvider.start();
                    }
                    ++n2;
                }
            }
            context.ungetService(serviceReference);
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipsetrader.news", 0, "Error reading news service", (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }

    public void terminate(IProgressMonitor monitor) {
        try {
            BundleContext context = Activator.getDefault().getBundle().getBundleContext();
            ServiceReference serviceReference = context.getServiceReference(NewsService.class.getName());
            if (serviceReference != null) {
                NewsService newsService = (NewsService)context.getService(serviceReference);
                INewsProvider[] iNewsProviderArray = newsService.getProviders();
                int n = iNewsProviderArray.length;
                int n2 = 0;
                while (n2 < n) {
                    INewsProvider newsProvider = iNewsProviderArray[n2];
                    newsProvider.stop();
                    ++n2;
                }
            }
            context.ungetService(serviceReference);
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipsetrader.news", 0, "Error reading news service", (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }
}

