/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.news.internal.preferences;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipsetrader.news.internal.Activator;
import org.eclipsetrader.news.internal.preferences.Messages;

public class NewsPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String K_ID = "id";
    private static final String K_NAME = "name";
    private Button followQuoteFeed;
    private Spinner daysToKeep;
    private Button enableDecorators;
    private CheckboxTableViewer providers;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.enableDecorators = new Button(content, 32);
        this.enableDecorators.setText(Messages.NewsPreferencesPage_EnableDecorators);
        this.enableDecorators.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.followQuoteFeed = new Button(content, 32);
        this.followQuoteFeed.setText(Messages.NewsPreferencesPage_FollowQuoteFeed);
        this.followQuoteFeed.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        Label label = new Label(content, 0);
        label.setText(Messages.NewsPreferencesPage_DaysToKeep);
        this.daysToKeep = new Spinner(content, 2048);
        this.daysToKeep.setMinimum(1);
        this.daysToKeep.setMaximum(9999);
        label = new Label(content, 0);
        label.setText(Messages.NewsPreferencesPage_Providers);
        label.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.providers = CheckboxTableViewer.newCheckList((Composite)content, (int)67588);
        this.providers.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.providers.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.providers.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IConfigurationElement)element).getAttribute(NewsPreferencesPage.K_NAME);
            }
        });
        this.providers.setSorter(new ViewerSorter());
        this.performDefaults();
        return content;
    }

    protected void performDefaults() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.followQuoteFeed.setSelection(store.getBoolean("FOLLOW_QUOTE_FEED"));
        this.daysToKeep.setSelection(store.getInt("DATE_RANGE"));
        this.enableDecorators.setSelection(store.getBoolean("ENABLE_DECORATORS"));
        IConfigurationElement[] elements = this.getProvidersConfigurationElements();
        this.providers.setInput((Object)elements);
        int i = 0;
        while (i < elements.length) {
            this.providers.setChecked((Object)elements[i], store.getBoolean(elements[i].getAttribute(K_ID)));
            ++i;
        }
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        store.setValue("FOLLOW_QUOTE_FEED", this.followQuoteFeed.getSelection());
        store.setValue("DATE_RANGE", this.daysToKeep.getSelection());
        store.setValue("ENABLE_DECORATORS", this.enableDecorators.getSelection());
        IConfigurationElement[] elements = this.getProvidersConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            String id = elements[i].getAttribute(K_ID);
            store.setValue(id, this.providers.getChecked((Object)elements[i]));
            ++i;
        }
        return super.performOk();
    }

    protected IConfigurationElement[] getProvidersConfigurationElements() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipsetrader.news.providers");
        return extensionPoint != null ? extensionPoint.getConfigurationElements() : new IConfigurationElement[]{};
    }
}

