/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.news.internal.preferences;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipsetrader.news.internal.Activator;
import org.eclipsetrader.news.internal.connectors.FeedSource;
import org.eclipsetrader.news.internal.preferences.Messages;
import org.eclipsetrader.news.internal.preferences.RSSFeedDialog;

public class RSSPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Spinner interval;
    private CheckboxTableViewer table;
    private Button editButton;
    private Button removeButton;
    private List<FeedSource> list = new ArrayList<FeedSource>();

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        Composite group = new Composite(content, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        Label label = new Label(group, 0);
        label.setText(Messages.RSSPreferencesPage_AutoUpdate);
        this.interval = new Spinner(group, 2048);
        this.interval.setMinimum(1);
        this.interval.setMaximum(9999);
        label = new Label(group, 0);
        label.setText(Messages.RSSPreferencesPage_Minutes);
        label = new Label(group, 0);
        label.setText(Messages.RSSPreferencesPage_Subscriptions);
        label.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.createViewer(content);
        group = new Composite(content, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(1, 1, false, false));
        Button button = new Button(group, 8);
        button.setText(Messages.RSSPreferencesPage_Add);
        button.setLayoutData((Object)new GridData(80, -1));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RSSFeedDialog dlg = new RSSFeedDialog(RSSPreferencesPage.this.getShell());
                if (dlg.open() == 0) {
                    FeedSource feedSource = dlg.getFeedSource();
                    feedSource.setEnabled(true);
                    RSSPreferencesPage.this.list.add(feedSource);
                    RSSPreferencesPage.this.table.refresh();
                    RSSPreferencesPage.this.table.setChecked((Object)feedSource, feedSource.isEnabled());
                    RSSPreferencesPage.this.table.setSelection((ISelection)new StructuredSelection((Object)feedSource), true);
                }
            }
        });
        this.editButton = new Button(group, 8);
        this.editButton.setText(Messages.RSSPreferencesPage_Edit);
        this.editButton.setEnabled(false);
        this.editButton.setLayoutData((Object)new GridData(80, -1));
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)RSSPreferencesPage.this.table.getSelection();
                FeedSource feedSource = (FeedSource)selection.getFirstElement();
                RSSFeedDialog dlg = new RSSFeedDialog(RSSPreferencesPage.this.getShell());
                dlg.setFeedSource(feedSource);
                if (dlg.open() == 0) {
                    RSSPreferencesPage.this.table.refresh();
                }
            }
        });
        this.removeButton = new Button(group, 8);
        this.removeButton.setText(Messages.RSSPreferencesPage_Remove);
        this.removeButton.setEnabled(false);
        this.removeButton.setLayoutData((Object)new GridData(80, -1));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)RSSPreferencesPage.this.table.getSelection();
                RSSPreferencesPage.this.list.removeAll(selection.toList());
                RSSPreferencesPage.this.table.remove(selection.toArray());
            }
        });
        this.performDefaults();
        return content;
    }

    protected void createViewer(Composite parent) {
        this.table = CheckboxTableViewer.newCheckList((Composite)parent, (int)67588);
        this.table.getTable().setHeaderVisible(false);
        this.table.getTable().setLinesVisible(false);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.table.getTable().getItemHeight() * 15 + this.table.getTable().getBorderWidth() * 2;
        this.table.getControl().setLayoutData((Object)gridData);
        this.table.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.table.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((FeedSource)element).getName();
            }
        });
        this.table.setSorter(new ViewerSorter());
        this.table.setInput(this.list);
        this.table.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RSSPreferencesPage.this.editButton.setEnabled(((IStructuredSelection)RSSPreferencesPage.this.table.getSelection()).size() == 1);
                RSSPreferencesPage.this.removeButton.setEnabled(!RSSPreferencesPage.this.table.getSelection().isEmpty());
            }
        });
        this.table.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ((FeedSource)event.getElement()).setEnabled(event.getChecked());
            }
        });
    }

    public boolean performOk() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        store.setValue("UPDATE_INTERVAL", this.interval.getSelection());
        try {
            File file = Activator.getDefault().getStateLocation().append("rss.xml").toFile();
            if (file.exists()) {
                file.delete();
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{FeedSource[].class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent event) {
                    Status status = new Status(2, "org.eclipsetrader.news", 0, "Error validating XML: " + event.getMessage(), null);
                    Activator.getDefault().getLog().log((IStatus)status);
                    return true;
                }
            });
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)System.getProperty("file.encoding"));
            JAXBElement element = new JAXBElement(new QName("list"), FeedSource[].class, (Object)this.list.toArray(new FeedSource[this.list.size()]));
            marshaller.marshal((Object)element, (Writer)new FileWriter(file));
        }
        catch (Exception exception) {
            Status status = new Status(2, "org.eclipsetrader.news", 0, "Error saving RSS subscriptions", null);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        return super.performOk();
    }

    protected void performDefaults() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.interval.setSelection(store.getInt("UPDATE_INTERVAL"));
        FeedSource[] sources = this.getSources();
        this.list.clear();
        this.list.addAll(Arrays.asList(sources));
        this.table.refresh();
        int i = 0;
        while (i < sources.length) {
            this.table.setChecked((Object)sources[i], sources[i].isEnabled());
            ++i;
        }
        super.performDefaults();
    }

    protected FeedSource[] getSources() {
        try {
            File file = Activator.getDefault().getStateLocation().append("rss.xml").toFile();
            if (file.exists()) {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{FeedSource[].class});
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                unmarshaller.setEventHandler(new ValidationEventHandler(){

                    public boolean handleEvent(ValidationEvent event) {
                        Status status = new Status(2, "org.eclipsetrader.news", 0, "Error validating XML: " + event.getMessage(), null);
                        Activator.getDefault().getLog().log((IStatus)status);
                        return true;
                    }
                });
                JAXBElement element = unmarshaller.unmarshal((Source)new StreamSource(file), FeedSource[].class);
                return (FeedSource[])element.getValue();
            }
        }
        catch (Exception exception) {
            Status status = new Status(2, "org.eclipsetrader.news", 0, "Error reading RSS subscriptions", null);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        return new FeedSource[0];
    }
}

