/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.news.internal.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.news.core.IHeadLine;
import org.eclipsetrader.news.internal.repository.DateTimeAdapter;
import org.eclipsetrader.news.internal.repository.SecurityAdapter;

@XmlRootElement(name="headline")
@XmlType(name="org.eclipsetrader.news.Headline")
public class HeadLine
implements IHeadLine {
    @XmlAttribute(name="date")
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private Date date;
    private boolean recent;
    @XmlAttribute(name="readed")
    private boolean readed;
    @XmlElement(name="text")
    private String text;
    @XmlElement(name="link")
    private String link;
    @XmlElement(name="source")
    private String source;
    @XmlElementWrapper(name="members")
    @XmlElement(name="security")
    @XmlJavaTypeAdapter(value=SecurityAdapter.class)
    private List<ISecurity> members;

    public HeadLine() {
    }

    public HeadLine(Date date, String source, String text, ISecurity[] members, String link) {
        this.date = date;
        this.source = source;
        this.text = text;
        this.members = members != null ? new ArrayList<ISecurity>(Arrays.asList(members)) : null;
        this.link = link;
    }

    @Override
    @XmlTransient
    public Date getDate() {
        return this.date;
    }

    @Override
    @XmlTransient
    public String getSource() {
        return this.source;
    }

    @Override
    @XmlTransient
    public String getText() {
        return this.text;
    }

    @Override
    public boolean contains(ISecurity security) {
        if (this.members == null) {
            return false;
        }
        return this.members.contains(security);
    }

    public void addMember(ISecurity security) {
        if (this.members == null) {
            this.members = new ArrayList<ISecurity>();
        }
        if (!this.members.contains(security)) {
            this.members.add(security);
        }
    }

    @Override
    @XmlTransient
    public ISecurity[] getMembers() {
        return this.members != null ? this.members.toArray(new ISecurity[this.members.size()]) : new ISecurity[]{};
    }

    @Override
    @XmlTransient
    public boolean isReaded() {
        return this.readed;
    }

    @Override
    public void setReaded(boolean readed) {
        this.readed = readed;
    }

    @Override
    @XmlTransient
    public boolean isRecent() {
        return this.recent;
    }

    public void setRecent(boolean recent) {
        this.recent = recent;
    }

    @Override
    @XmlTransient
    public String getLink() {
        return this.link;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IHeadLine)) {
            return false;
        }
        IHeadLine other = (IHeadLine)obj;
        if (this.link.equals(other.getLink())) {
            return true;
        }
        return this.text.equals(other.getText()) && (this.source == other.getSource() || this.source != null && this.source.equals(other.getSource()));
    }

    public int hashCode() {
        return 3 * this.text.hashCode() + 7 * (this.source != null ? this.source.hashCode() : 0);
    }
}

