/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.news.internal.ui;

import java.text.DateFormat;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.news.core.IHeadLine;

public class HeadLineLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider,
IFontProvider {
    private DateFormat formatter = DateFormat.getDateTimeInstance(2, 3);
    private Color addedBackground;
    private Color addedForeground = Display.getCurrent().getSystemColor(26);
    private Font addedFont;
    private Color readedBackground;
    private Color readedForeground = Display.getCurrent().getSystemColor(18);
    private Font readedFont;

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        IHeadLine newsItem = (IHeadLine)element;
        switch (columnIndex) {
            case 0: {
                return this.formatter.format(newsItem.getDate());
            }
            case 1: {
                return this.getSafeString(newsItem.getText());
            }
            case 2: {
                String text = "";
                ISecurity[] o = newsItem.getMembers();
                int i = 0;
                while (i < o.length) {
                    if (!text.equals("")) {
                        text = String.valueOf(text) + ", ";
                    }
                    text = String.valueOf(text) + o[i].getName();
                    ++i;
                }
                return text;
            }
            case 3: {
                return newsItem.getSource();
            }
        }
        return "";
    }

    protected String getSafeString(String title) {
        title = title.replaceAll("&agrave;", "\u00e0");
        title = title.replaceAll("&egrave;", "\u00e8");
        title = title.replaceAll("&eacute;", "\u00e9");
        title = title.replaceAll("&igrave;", "\u00ec");
        title = title.replaceAll("&ograve;", "\u00f2");
        title = title.replaceAll("&pgrave;", "\u00f9");
        return title;
    }

    public Color getBackground(Object element) {
        IHeadLine newsItem = (IHeadLine)element;
        if (newsItem.isReaded()) {
            return this.readedBackground;
        }
        if (newsItem.isRecent()) {
            return this.addedBackground;
        }
        return null;
    }

    public Color getForeground(Object element) {
        IHeadLine newsItem = (IHeadLine)element;
        if (newsItem.isReaded()) {
            return this.readedForeground;
        }
        if (newsItem.isRecent()) {
            return this.addedForeground;
        }
        return null;
    }

    public Font getFont(Object element) {
        IHeadLine newsItem = (IHeadLine)element;
        if (newsItem.isReaded()) {
            return this.readedFont;
        }
        if (newsItem.isRecent()) {
            return this.addedFont;
        }
        return null;
    }

    public void setAddedBackground(Color addedBackground) {
        this.addedBackground = addedBackground;
    }

    public void setAddedFont(Font addedFont) {
        this.addedFont = addedFont;
    }

    public void setAddedForeground(Color addedForeground) {
        this.addedForeground = addedForeground;
    }

    public void setReadedBackground(Color readedBackground) {
        this.readedBackground = readedBackground;
    }

    public void setReadedFont(Font readedFont) {
        this.readedFont = readedFont;
    }

    public void setReadedForeground(Color readedForeground) {
        this.readedForeground = readedForeground;
    }
}

