/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.news.internal.ui;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipsetrader.news.core.IHeadLine;
import org.eclipsetrader.news.internal.repository.HeadLine;
import org.eclipsetrader.news.internal.ui.ImageResource;
import org.eclipsetrader.news.internal.ui.SelectionProvider;

public class NewsViewer
extends ViewPart {
    public static final String VIEW_ID = "org.eclipsetrader.news.browser";
    private Action stopAction;
    private Action refreshAction;
    private Browser browser;
    private IHeadLine headLine;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            String title = memento.getString("title");
            String url = memento.getString("url");
            if (url != null) {
                this.headLine = new HeadLine(null, null, title != null ? title : "", null, url);
            }
        }
        this.stopAction = new Action("Stop"){

            public void run() {
                NewsViewer.this.browser.stop();
            }
        };
        this.stopAction.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ELCL_NAV_STOP"));
        this.stopAction.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DLCL_NAV_STOP"));
        this.stopAction.setEnabled(false);
        this.refreshAction = new Action("Refresh"){

            public void run() {
                NewsViewer.this.stopAction.setEnabled(true);
                NewsViewer.this.refreshAction.setEnabled(false);
                NewsViewer.this.browser.refresh();
            }
        };
        this.refreshAction.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ELCL_NAV_REFRESH"));
        this.refreshAction.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DLCL_NAV_REFRESH"));
        this.refreshAction.setEnabled(false);
        IToolBarManager toolbarManager = site.getActionBars().getToolBarManager();
        toolbarManager.add((IAction)this.refreshAction);
        toolbarManager.add((IAction)this.stopAction);
        toolbarManager.add((IContributionItem)new Separator("additions"));
        site.getActionBars().updateActionBars();
        site.setSelectionProvider((ISelectionProvider)new SelectionProvider());
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (this.headLine != null) {
            memento.putString("title", this.headLine.getText());
            memento.putString("url", this.headLine.getLink());
        }
    }

    public void createPartControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        content.setLayout((Layout)gridLayout);
        this.browser = new Browser(content, 0);
        this.browser.setLayoutData((Object)new GridData(4, 4, true, true));
        this.browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event) {
                NewsViewer.this.setTitleToolTip(event.title);
            }
        });
        this.browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                NewsViewer.this.stopAction.setEnabled(false);
                NewsViewer.this.refreshAction.setEnabled(true);
            }
        });
        this.browser.addLocationListener(new LocationListener(){

            public void changed(LocationEvent event) {
            }

            public void changing(LocationEvent event) {
                NewsViewer.this.stopAction.setEnabled(true);
                NewsViewer.this.refreshAction.setEnabled(false);
            }
        });
        this.browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                event.browser = NewsViewer.this.browser;
            }
        });
        this.setTitleToolTip(this.getPartName());
        if (this.headLine != null) {
            this.setHeadLine(this.headLine);
        }
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public IHeadLine getHeadLine() {
        return this.headLine;
    }

    public void setHeadLine(IHeadLine headLine) {
        this.headLine = headLine;
        this.browser.setUrl(headLine.getLink());
        this.setPartName(headLine.getText());
        this.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)headLine));
    }
}

