/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.ValueProperty;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipsetrader.ui.Util;

public class CellEditorDateValueProperty
extends ValueProperty {
    DateFormat dateFormat = Util.getDateFormat();

    public Object getValueType() {
        return Date.class;
    }

    public IObservableValue observe(Realm realm, Object source) {
        return new CellEditorObservable(realm, (CellEditor)source);
    }

    private class CellEditorObservable
    extends AbstractObservableValue {
        final CellEditor cellEditor;
        Object oldValue;
        final ICellEditorListener cellEditorListener = new ICellEditorListener(){

            public void applyEditorValue() {
            }

            public void cancelEditor() {
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                CellEditorObservable.this.fireChangeEvent();
            }
        };

        public CellEditorObservable(Realm realm, CellEditor cellEditor) {
            this.cellEditor = cellEditor;
            cellEditor.addListener(this.cellEditorListener);
        }

        public synchronized void dispose() {
            this.cellEditor.removeListener(this.cellEditorListener);
            super.dispose();
        }

        public Object getValueType() {
            return Date.class;
        }

        protected void doSetValue(Object value) {
            if (value instanceof Date) {
                this.cellEditor.setValue((Object)CellEditorDateValueProperty.this.dateFormat.format(value));
                this.oldValue = value;
            } else {
                this.cellEditor.setValue((Object)"");
                this.oldValue = null;
            }
        }

        protected Object doGetValue() {
            String text = (String)this.cellEditor.getValue();
            try {
                if (text != null && !"".equals(text)) {
                    return CellEditorDateValueProperty.this.dateFormat.parse(text);
                }
            }
            catch (ParseException parseException) {}
            return null;
        }

        private void fireChangeEvent() {
            Object newValue = this.doGetValue();
            if (!this.equals(this.oldValue, newValue)) {
                this.fireValueChange(Diffs.createValueDiff((Object)this.oldValue, (Object)newValue));
                this.oldValue = newValue;
            }
        }

        private boolean equals(Object left, Object right) {
            return left == null ? right == null : right != null && left.equals(right);
        }
    }
}

