/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.charts.OHLCDataSeries;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.ui.charts.ChartObjectFocusEvent;
import org.eclipsetrader.ui.charts.DataBounds;
import org.eclipsetrader.ui.charts.Graphics;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectVisitor;
import org.eclipsetrader.ui.charts.IGraphics;
import org.eclipsetrader.ui.charts.ISummaryBarDecorator;
import org.eclipsetrader.ui.charts.SummaryDateItem;
import org.eclipsetrader.ui.charts.SummaryOHLCItem;

public class BarChart
implements IChartObject,
ISummaryBarDecorator,
IAdaptable {
    private IDataSeries dataSeries;
    private int width = 5;
    private RGB positiveColor = new RGB(0, 254, 0);
    private RGB negativeColor = new RGB(254, 0, 0);
    private IAdaptable[] values;
    private List<Bar> pointArray;
    private boolean valid;
    private boolean hasFocus;
    private SummaryDateItem dateItem;
    private SummaryOHLCItem ohlcItem;
    private DateFormat dateFormat = DateFormat.getDateInstance();
    private NumberFormat numberFormat = NumberFormat.getInstance();

    public BarChart(IDataSeries dataSeries) {
        TimeSpan resolution;
        this.dataSeries = dataSeries;
        if (dataSeries instanceof OHLCDataSeries && (resolution = ((OHLCDataSeries)dataSeries).getResolution()) != null && resolution.getUnits() == TimeSpan.Units.Minutes) {
            this.dateFormat = DateFormat.getDateTimeInstance();
        }
        this.numberFormat.setGroupingUsed(true);
        this.numberFormat.setMinimumIntegerDigits(1);
        this.numberFormat.setMinimumFractionDigits(0);
        this.numberFormat.setMaximumFractionDigits(4);
    }

    public BarChart(IDataSeries dataSeries, RGB positiveColor, RGB negativeColor) {
        TimeSpan resolution;
        this.dataSeries = dataSeries;
        if (positiveColor != null) {
            this.positiveColor = positiveColor;
        }
        if (negativeColor != null) {
            this.negativeColor = negativeColor;
        }
        if (dataSeries instanceof OHLCDataSeries && (resolution = ((OHLCDataSeries)dataSeries).getResolution()) != null && resolution.getUnits() == TimeSpan.Units.Minutes) {
            this.dateFormat = DateFormat.getDateTimeInstance();
        }
        this.numberFormat.setGroupingUsed(true);
        this.numberFormat.setMinimumIntegerDigits(1);
        this.numberFormat.setMinimumFractionDigits(0);
        this.numberFormat.setMaximumFractionDigits(4);
    }

    @Override
    public void setDataBounds(DataBounds dataBounds) {
        ArrayList<IAdaptable> l = new ArrayList<IAdaptable>(2048);
        IAdaptable[] iAdaptableArray = this.dataSeries.getValues();
        int n = iAdaptableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable value = iAdaptableArray[n2];
            Date date = (Date)value.getAdapter(Date.class);
            if (!(dataBounds.first != null && date.before(dataBounds.first) || dataBounds.last != null && date.after(dataBounds.last))) {
                l.add(value);
            }
            ++n2;
        }
        this.values = l.toArray(new IAdaptable[l.size()]);
        this.width = dataBounds.horizontalSpacing;
        this.valid = false;
    }

    @Override
    public void invalidate() {
        this.valid = false;
    }

    @Override
    public void paint(IGraphics graphics) {
        if (!this.valid || this.pointArray == null && this.values != null) {
            if (this.pointArray == null) {
                this.pointArray = new ArrayList<Bar>(this.values.length);
            }
            int i = 0;
            while (i < this.values.length) {
                IOHLC ohlc = (IOHLC)this.values[i].getAdapter(IOHLC.class);
                if (ohlc != null) {
                    Bar bar;
                    int h = graphics.mapToVerticalAxis(ohlc.getHigh());
                    int l = graphics.mapToVerticalAxis(ohlc.getLow());
                    int c = graphics.mapToVerticalAxis(ohlc.getClose());
                    int o = graphics.mapToVerticalAxis(ohlc.getOpen());
                    int x = graphics.mapToHorizontalAxis(ohlc.getDate());
                    if (i < this.pointArray.size()) {
                        bar = this.pointArray.get(i);
                        bar.setBounds(x, h, o, c, l);
                    } else {
                        bar = new Bar(x, h, o, c, l);
                        this.pointArray.add(bar);
                    }
                    bar.setOhlc(ohlc);
                    bar.setColor(ohlc.getClose() < ohlc.getOpen() ? this.negativeColor : this.positiveColor);
                }
                ++i;
            }
            while (this.pointArray.size() > this.values.length) {
                this.pointArray.remove(this.pointArray.size() - 1);
            }
            this.valid = true;
        }
        if (this.pointArray != null) {
            graphics.pushState();
            graphics.setLineWidth(this.hasFocus ? 2 : 1);
            for (Bar c : this.pointArray) {
                c.paint(graphics);
            }
            graphics.popState();
        }
    }

    @Override
    public void paintScale(Graphics graphics) {
    }

    @Override
    public boolean containsPoint(int x, int y) {
        if (this.pointArray != null) {
            for (Bar c : this.pointArray) {
                if (!c.containsPoint(x, y)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public IDataSeries getDataSeries() {
        return this.dataSeries;
    }

    @Override
    public String getToolTip() {
        if (this.dataSeries.getLast() != null) {
            IOHLC ohlc = (IOHLC)this.dataSeries.getLast().getAdapter(IOHLC.class);
            return String.valueOf(this.dateFormat.format(ohlc.getDate())) + " O:" + this.numberFormat.format(ohlc.getOpen()) + " H:" + this.numberFormat.format(ohlc.getHigh()) + " L:" + this.numberFormat.format(ohlc.getLow()) + " C:" + this.numberFormat.format(ohlc.getHigh());
        }
        return this.dataSeries.getName();
    }

    @Override
    public String getToolTip(int x, int y) {
        if (this.pointArray != null) {
            for (Bar c : this.pointArray) {
                if (!c.containsPoint(x, y)) continue;
                return c.getToolTip();
            }
        }
        return null;
    }

    @Override
    public void handleFocusGained(ChartObjectFocusEvent event) {
        this.hasFocus = true;
    }

    @Override
    public void handleFocusLost(ChartObjectFocusEvent event) {
        this.hasFocus = false;
    }

    @Override
    public void accept(IChartObjectVisitor visitor) {
        visitor.visit(this);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ISummaryBarDecorator.class)) {
            return this;
        }
        return null;
    }

    @Override
    public void createDecorator(Composite parent) {
        IAdaptable[] values = this.dataSeries.getValues();
        IOHLC ohlc = (IOHLC)(values.length > 0 ? values[values.length - 1].getAdapter(IOHLC.class) : null);
        IOHLC previousOhlc = (IOHLC)(values.length > 1 ? values[values.length - 2].getAdapter(IOHLC.class) : null);
        this.dateItem = new SummaryDateItem(parent, 32);
        this.dateItem.setDate(ohlc != null ? ohlc.getDate() : null);
        this.ohlcItem = new SummaryOHLCItem(parent, 0);
        this.ohlcItem.setOHLC(ohlc, previousOhlc);
    }

    @Override
    public void updateDecorator(int x, int y) {
        if (x == -1) {
            IAdaptable[] values = this.dataSeries.getValues();
            IOHLC ohlc = (IOHLC)(values.length > 0 ? values[values.length - 1].getAdapter(IOHLC.class) : null);
            IOHLC previousOhlc = (IOHLC)(values.length > 1 ? values[values.length - 2].getAdapter(IOHLC.class) : null);
            this.dateItem.setDate(ohlc != null ? ohlc.getDate() : null);
            this.ohlcItem.setOHLC(ohlc, previousOhlc);
        } else if (this.pointArray != null) {
            int i = 1;
            while (i < this.pointArray.size()) {
                Bar c = this.pointArray.get(i);
                if (c.containsPoint(x, y)) {
                    this.dateItem.setDate(c.ohlc.getDate());
                    this.ohlcItem.setOHLC(c.ohlc, this.pointArray.get((int)(i - 1)).ohlc);
                }
                ++i;
            }
        }
    }

    private class Bar {
        int x;
        int yHigh;
        int yOpen;
        int yClose;
        int yLow;
        IOHLC ohlc;
        RGB color;

        public Bar(int x, int yHigh, int yOpen, int yClose, int yLow) {
            this.x = x;
            this.yHigh = yHigh;
            this.yOpen = yOpen;
            this.yClose = yClose;
            this.yLow = yLow;
        }

        public void setBounds(int x, int yHigh, int yOpen, int yClose, int yLow) {
            this.x = x;
            this.yHigh = yHigh;
            this.yOpen = yOpen;
            this.yClose = yClose;
            this.yLow = yLow;
        }

        public void setOhlc(IOHLC ohlc) {
            this.ohlc = ohlc;
        }

        public void setColor(RGB color) {
            this.color = color;
        }

        public void paint(IGraphics graphics) {
            graphics.setForegroundColor(this.color);
            graphics.drawLine(this.x, this.yHigh, this.x, this.yLow);
            graphics.drawLine(this.x - BarChart.this.width / 2, this.yOpen, this.x, this.yOpen);
            graphics.drawLine(this.x, this.yClose, this.x + BarChart.this.width / 2, this.yClose);
        }

        public boolean containsPoint(int x, int y) {
            if (y == -1) {
                return x >= this.x - BarChart.this.width / 2 && x <= this.x + BarChart.this.width / 2;
            }
            if (x == this.x || x == -1) {
                return y >= this.yHigh && y <= this.yLow;
            }
            if (x >= this.x - BarChart.this.width / 2 && x <= this.x + BarChart.this.width / 2) {
                return y >= this.yHigh && y <= this.yLow;
            }
            return false;
        }

        public String getToolTip() {
            return String.valueOf(BarChart.this.dataSeries.getName()) + "\r\nD:" + BarChart.this.dateFormat.format(this.ohlc.getDate()) + "\r\nO:" + BarChart.this.numberFormat.format(this.ohlc.getOpen()) + "\r\nH:" + BarChart.this.numberFormat.format(this.ohlc.getHigh()) + "\r\nL:" + BarChart.this.numberFormat.format(this.ohlc.getLow()) + "\r\nC:" + BarChart.this.numberFormat.format(this.ohlc.getClose());
        }
    }
}

