/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts;

import java.util.Date;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipsetrader.ui.charts.BaseChartViewer;
import org.eclipsetrader.ui.charts.ChartCanvas;
import org.eclipsetrader.ui.charts.Graphics;
import org.eclipsetrader.ui.charts.IChartEditorListener;
import org.eclipsetrader.ui.charts.IEditableChartObject;
import org.eclipsetrader.ui.charts.IGraphics;

public class ChartToolEditor {
    private BaseChartViewer viewer;
    private ChartCanvas chartCanvas;
    private Graphics graphics;
    private IEditableChartObject object;
    private ListenerList listeners = new ListenerList(1);
    private MouseListener mouseListener = new MouseListener(){

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            ChartToolEditor.this.handleMouseDown(ChartToolEditor.this.createEvent(e));
        }

        public void mouseUp(MouseEvent e) {
            ChartToolEditor.this.handleMouseUp(ChartToolEditor.this.createEvent(e));
        }
    };
    private MouseMoveListener mouseMoveListener = new MouseMoveListener(){

        public void mouseMove(MouseEvent e) {
            ChartToolEditor.this.handleMouseMove(ChartToolEditor.this.createEvent(e));
        }
    };

    public void activate(BaseChartViewer viewer, ChartCanvas chartCanvas, IEditableChartObject object) {
        if (this.chartCanvas != null) {
            this.deactivate();
        }
        this.viewer = viewer;
        this.chartCanvas = chartCanvas;
        this.object = object;
        this.graphics = new Graphics((Drawable)chartCanvas.getCanvas(), viewer.getLocation(), viewer.datesAxis, chartCanvas.getVerticalAxis());
        chartCanvas.getCanvas().addMouseListener(this.mouseListener);
        chartCanvas.getCanvas().addMouseMoveListener(this.mouseMoveListener);
    }

    public boolean isActive() {
        return this.object != null;
    }

    public void cancelEditing() {
        if (this.object != null) {
            Object[] l = this.listeners.getListeners();
            int i = 0;
            while (i < l.length) {
                try {
                    ((IChartEditorListener)l[i]).cancelEditor();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                ++i;
            }
            this.deactivate();
        }
    }

    public void applyEditing() {
        if (this.object != null) {
            Object[] l = this.listeners.getListeners();
            int i = 0;
            while (i < l.length) {
                try {
                    ((IChartEditorListener)l[i]).applyEditorValue();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                ++i;
            }
            this.deactivate();
        }
    }

    private void deactivate() {
        if (this.object != null) {
            if (this.chartCanvas != null) {
                this.chartCanvas.getCanvas().removeMouseListener(this.mouseListener);
                this.chartCanvas.getCanvas().removeMouseMoveListener(this.mouseMoveListener);
                this.chartCanvas = null;
            }
            if (this.graphics != null) {
                this.graphics.dispose();
                this.graphics = null;
            }
            this.object = null;
        }
    }

    protected void handleMouseDown(ChartObjectEditorEvent e) {
        if (this.object != null) {
            this.object.handleMouseDown(e);
            this.chartCanvas.getCanvas().setData("needs_redraw", (Object)Boolean.TRUE);
        }
    }

    protected void handleMouseUp(ChartObjectEditorEvent e) {
        if (this.object != null) {
            this.object.handleMouseUp(e);
            this.applyEditing();
            this.viewer.deactivateEditor();
        }
    }

    protected void handleMouseMove(ChartObjectEditorEvent e) {
        if (this.object != null) {
            this.object.handleMouseMove(e);
        }
    }

    public ChartCanvas getChartCanvas() {
        return this.chartCanvas;
    }

    public IEditableChartObject getObject() {
        return this.object;
    }

    protected ChartObjectEditorEvent createEvent(MouseEvent e) {
        ChartObjectEditorEvent event = new ChartObjectEditorEvent();
        event.x = e.x;
        event.y = e.y;
        event.date = (Date)this.viewer.datesAxis.mapToValue(e.x + this.viewer.getLocation().x);
        event.value = (Number)this.chartCanvas.getVerticalAxis().mapToValue(e.y);
        event.button = e.button;
        event.count = e.count;
        event.display = e.display;
        event.chartCanvas = this.chartCanvas;
        event.canvas = this.chartCanvas.getCanvas();
        event.graphics = this.graphics;
        return event;
    }

    public void addListener(IChartEditorListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(IChartEditorListener listener) {
        this.listeners.remove((Object)listener);
    }

    public static class ChartObjectEditorEvent {
        public int x;
        public int y;
        public Date date;
        public Number value;
        public int button;
        public int count;
        public Display display;
        public ChartCanvas chartCanvas;
        public Canvas canvas;
        public IGraphics graphics;
    }
}

