/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.charts.repository.IChartSection;
import org.eclipsetrader.core.charts.repository.IChartTemplate;
import org.eclipsetrader.core.internal.charts.repository.ChartTemplate;
import org.eclipsetrader.core.views.IView;
import org.eclipsetrader.core.views.IViewChangeListener;
import org.eclipsetrader.core.views.IViewItem;
import org.eclipsetrader.core.views.IViewItemVisitor;
import org.eclipsetrader.core.views.IViewVisitor;
import org.eclipsetrader.core.views.ViewEvent;
import org.eclipsetrader.core.views.ViewItemDelta;
import org.eclipsetrader.ui.charts.ChartRowViewItem;
import org.eclipsetrader.ui.charts.Messages;
import org.eclipsetrader.ui.internal.UIActivator;

public class ChartView
implements IView {
    private String name;
    private List<ChartRowViewItem> rows = new ArrayList<ChartRowViewItem>();
    private ListenerList listeners = new ListenerList(1);
    private IDataSeries rootDataSeries;

    protected ChartView() {
    }

    public ChartView(String name) {
        this.name = name;
    }

    public ChartView(IChartTemplate template) {
        this.name = template.getName();
        IChartSection[] section = template.getSections();
        int i = 0;
        while (i < section.length) {
            ChartRowViewItem viewItem = new ChartRowViewItem(this, section[i]);
            this.rows.add(viewItem);
            ++i;
        }
    }

    public String getName() {
        return this.name;
    }

    public void dispose() {
        this.listeners.clear();
        this.rows.clear();
    }

    public void addRow(ChartRowViewItem viewItem) {
        this.rows.add(viewItem);
        this.fireViewChangedEvent(new ViewItemDelta[]{new ViewItemDelta(1, (IViewItem)viewItem)});
    }

    public void addRowBefore(ChartRowViewItem referenceViewItem, ChartRowViewItem viewItem) {
        int index = this.rows.indexOf(referenceViewItem);
        this.rows.add(index != -1 ? index : 0, viewItem);
        this.fireViewChangedEvent(new ViewItemDelta[]{new ViewItemDelta(1, (IViewItem)viewItem)});
    }

    public void addRowAfter(ChartRowViewItem referenceViewItem, ChartRowViewItem viewItem) {
        int index = this.rows.indexOf(referenceViewItem);
        this.rows.add(index != -1 ? index + 1 : this.rows.size(), viewItem);
        this.fireViewChangedEvent(new ViewItemDelta[]{new ViewItemDelta(1, (IViewItem)viewItem)});
    }

    public void removeRow(ChartRowViewItem viewItem) {
        this.rows.remove(viewItem);
        this.fireViewChangedEvent(new ViewItemDelta[]{new ViewItemDelta(2, (IViewItem)viewItem)});
    }

    public IDataSeries getRootDataSeries() {
        return this.rootDataSeries;
    }

    public void setRootDataSeries(IDataSeries rootDataSeries) {
        this.rootDataSeries = rootDataSeries;
        for (ChartRowViewItem viewItem : this.rows) {
            viewItem.setRootDataSeries(rootDataSeries);
        }
    }

    protected void fireViewChangedEvent(ViewItemDelta[] delta) {
        ViewEvent event = new ViewEvent((IView)this, delta);
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            try {
                ((IViewChangeListener)l[i]).viewChanged(event);
            }
            catch (Throwable e) {
                Status status = new Status(4, "org.eclipsetrader.ui", Messages.ChartView_NotificationErrorMessage, e);
                UIActivator.log((IStatus)status);
            }
            ++i;
        }
    }

    public IViewItem[] getItems() {
        return this.rows.toArray(new IViewItem[this.rows.size()]);
    }

    public void addViewChangeListener(IViewChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeViewChangeListener(IViewChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ChartRowViewItem[].class)) {
            return this.rows.toArray(new ChartRowViewItem[this.rows.size()]);
        }
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public void accept(IViewVisitor visitor) {
        if (visitor.visit((IView)this)) {
            IViewItem[] child = this.getItems();
            int i = 0;
            while (i < child.length) {
                child[i].accept((IViewItemVisitor)visitor);
                ++i;
            }
        }
    }

    public IChartTemplate getTemplate() {
        ChartTemplate template = new ChartTemplate(this.name);
        IChartSection[] section = new IChartSection[this.rows.size()];
        int i = 0;
        while (i < section.length) {
            section[i] = this.rows.get(i).getTemplate();
            ++i;
        }
        template.setSections(section);
        return template;
    }
}

