/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipsetrader.ui.charts.IAxis;

public class DateValuesAxis
implements IAxis {
    public double gridSize = 5.0;
    public int additionalSpace = 0;
    public boolean fillAvailableSpace;
    public int zoomFactor = 0;
    private List<Date> sortedList = new ArrayList<Date>();

    @Override
    public void addValues(Object[] values) {
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object v = objectArray[n2];
            Date value = null;
            if (v instanceof Date) {
                value = (Date)v;
            }
            if (v instanceof IAdaptable) {
                value = (Date)((IAdaptable)v).getAdapter(Date.class);
            }
            if (value != null && !this.sortedList.contains(value)) {
                this.sortedList.add(value);
            }
            ++n2;
        }
        Collections.sort(this.sortedList);
    }

    @Override
    public void clear() {
        this.sortedList.clear();
    }

    @Override
    public int computeSize(int preferredSize) {
        if (this.fillAvailableSpace) {
            this.gridSize = (double)preferredSize / (double)this.sortedList.size();
            return preferredSize;
        }
        return (int)(this.gridSize * (double)this.sortedList.size() + this.gridSize * (double)this.additionalSpace);
    }

    @Override
    public int mapToAxis(Object value) {
        if (value instanceof Date) {
            int index = Collections.binarySearch(this.sortedList, (Date)value);
            if (index < 0) {
                index = -(index + 1);
            }
            return (int)(this.gridSize / 2.0 + (double)index * this.gridSize);
        }
        return 0;
    }

    @Override
    public Object mapToValue(int position) {
        if (this.sortedList.size() == 0) {
            return null;
        }
        int index = (int)((double)position / this.gridSize);
        if (index < 0) {
            index = 0;
        }
        if (index >= this.sortedList.size()) {
            index = this.sortedList.size() - 1;
        }
        return this.sortedList.get(index);
    }

    @Override
    public Object getFirstValue() {
        return this.sortedList.size() != 0 ? this.sortedList.get(0) : null;
    }

    @Override
    public Object getLastValue() {
        return this.sortedList.size() != 0 ? this.sortedList.get(this.sortedList.size() - 1) : null;
    }

    @Override
    public Object[] getValues() {
        return this.sortedList.toArray(new Date[this.sortedList.size()]);
    }

    public int getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(int zoomFactor) {
        this.fillAvailableSpace = false;
        this.zoomFactor = zoomFactor;
        this.gridSize = zoomFactor != 0 ? 5.0 + 2.0 * (double)zoomFactor : 5.0;
    }
}

