/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.ui.charts.IAxis;

public class DoubleValuesAxis
implements IAxis {
    public int marginHeight = 5;
    private Double scaleHigh;
    private Double scaleLow;
    private int height;
    private double span;
    private double[] scaleList = new double[]{1.0E-4, 2.0E-4, 5.0E-4, 0.001, 0.002, 0.005, 0.01, 0.02, 0.05, 0.1, 0.2, 0.5, 1.0, 2.0, 5.0, 10.0, 25.0, 50.0, 100.0, 250.0, 500.0, 1000.0, 2500.0, 5000.0, 10000.0, 25000.0, 50000.0, 100000.0, 250000.0, 500000.0, 1000000.0, 2500000.0, 5000000.0, 1.0E7, 2.5E7, 5.0E7, 1.0E8, 2.5E8, 5.0E8, 1.0E9, 2.5E9, 5.0E9, 1.0E10, 2.5E10, 5.0E10, 1.0E11, 2.5E11, 5.0E11};

    @Override
    public void addValues(Object[] values) {
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object v = objectArray[n2];
            Number highValue = null;
            Number lowValue = null;
            if (v instanceof Number) {
                highValue = lowValue = (Number)v;
            }
            if (v instanceof IAdaptable) {
                IOHLC ohlc = (IOHLC)((IAdaptable)v).getAdapter(IOHLC.class);
                if (ohlc != null) {
                    highValue = ohlc.getHigh();
                    lowValue = ohlc.getLow();
                } else {
                    highValue = lowValue = (Number)((IAdaptable)v).getAdapter(Number.class);
                }
            }
            if (highValue != null && (this.scaleHigh == null || highValue.doubleValue() > this.scaleHigh)) {
                this.scaleHigh = highValue.doubleValue();
            }
            if (lowValue != null && (this.scaleLow == null || lowValue.doubleValue() < this.scaleLow)) {
                this.scaleLow = lowValue.doubleValue();
            }
            ++n2;
        }
        if (this.scaleHigh != null && this.scaleLow != null) {
            this.span = (double)(this.height - this.marginHeight * 2) / (this.scaleHigh - this.scaleLow);
        }
    }

    @Override
    public void clear() {
        this.scaleHigh = null;
        this.scaleLow = null;
        this.span = 0.0;
    }

    @Override
    public int computeSize(int preferredSize) {
        this.height = preferredSize;
        if (this.scaleHigh != null && this.scaleLow != null) {
            this.span = (double)(this.height - this.marginHeight * 2) / (this.scaleHigh - this.scaleLow);
        }
        return this.height;
    }

    @Override
    public int mapToAxis(Object value) {
        Number n = null;
        if (value instanceof Number) {
            n = (Number)value;
        }
        if (value instanceof IAdaptable) {
            n = (Number)((IAdaptable)value).getAdapter(Number.class);
        }
        if (n == null || this.scaleLow == null) {
            return 0;
        }
        double t = n.doubleValue() - this.scaleLow;
        int y = (int)(t * this.span);
        return this.height - y - this.marginHeight;
    }

    @Override
    public Object mapToValue(int position) {
        if (this.height == 0 || this.scaleLow == null) {
            return 0;
        }
        int p = this.height - position - this.marginHeight;
        return this.scaleLow + (double)p / this.span;
    }

    @Override
    public Object getFirstValue() {
        return this.scaleLow;
    }

    @Override
    public Object getLastValue() {
        return this.scaleHigh;
    }

    @Override
    public Object[] getValues() {
        if (this.scaleHigh == null || this.scaleLow == null) {
            return new Object[0];
        }
        int ticks = 2;
        while (ticks * 15 < this.height) {
            ++ticks;
        }
        if (--ticks > 10) {
            ticks = 10;
        }
        double range = this.scaleHigh - this.scaleLow;
        double interval = 0.0;
        int loop = 0;
        while (loop < this.scaleList.length) {
            interval = this.scaleList[loop];
            if (range / interval < (double)ticks) break;
            ++loop;
        }
        loop = 0;
        double t = 0.0 - (double)ticks * interval;
        ArrayList<Double> scaleArray = new ArrayList<Double>();
        if (interval > 0.0) {
            while (t <= this.scaleHigh) {
                if (!((t += interval) >= this.scaleLow)) continue;
                scaleArray.add(new Double(t));
                ++loop;
            }
        }
        return scaleArray.toArray(new Double[scaleArray.size()]);
    }
}

