/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.ui.charts.ChartObjectFocusEvent;
import org.eclipsetrader.ui.charts.DataBounds;
import org.eclipsetrader.ui.charts.Graphics;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectVisitor;
import org.eclipsetrader.ui.charts.IGraphics;
import org.eclipsetrader.ui.charts.ISummaryBarDecorator;
import org.eclipsetrader.ui.charts.PixelTools;
import org.eclipsetrader.ui.charts.SummaryDateItem;
import org.eclipsetrader.ui.charts.SummaryOHLCItem;

public class OHLCLineChart
implements IChartObject,
ISummaryBarDecorator,
IAdaptable {
    private IDataSeries dataSeries;
    private LineStyle style;
    private RGB color;
    private int width = 5;
    private IAdaptable[] values;
    private Point[] pointArray;
    private boolean valid;
    private boolean hasFocus;
    private SummaryDateItem dateItem;
    private SummaryOHLCItem ohlcItem;
    private DateFormat dateFormat = DateFormat.getDateInstance();
    private NumberFormat numberFormat = NumberFormat.getInstance();

    public OHLCLineChart(IDataSeries dataSeries, LineStyle style, RGB color) {
        this.dataSeries = dataSeries;
        this.style = style;
        this.color = color;
        this.numberFormat.setGroupingUsed(true);
        this.numberFormat.setMinimumIntegerDigits(1);
        this.numberFormat.setMinimumFractionDigits(0);
        this.numberFormat.setMaximumFractionDigits(4);
    }

    public RGB getColor() {
        return this.color;
    }

    public void setColor(RGB color) {
        this.color = color;
    }

    @Override
    public void setDataBounds(DataBounds dataBounds) {
        ArrayList<IAdaptable> l = new ArrayList<IAdaptable>(2048);
        IAdaptable[] iAdaptableArray = this.dataSeries.getValues();
        int n = iAdaptableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable value = iAdaptableArray[n2];
            Date date = (Date)value.getAdapter(Date.class);
            if (!(dataBounds.first != null && date.before(dataBounds.first) || dataBounds.last != null && date.after(dataBounds.last))) {
                l.add(value);
            }
            ++n2;
        }
        this.values = l.toArray(new IAdaptable[l.size()]);
        this.width = dataBounds.horizontalSpacing;
        this.valid = false;
    }

    @Override
    public void handleFocusGained(ChartObjectFocusEvent event) {
        this.hasFocus = true;
    }

    @Override
    public void handleFocusLost(ChartObjectFocusEvent event) {
        this.hasFocus = false;
    }

    protected boolean hasFocus() {
        return this.hasFocus;
    }

    @Override
    public void invalidate() {
        this.valid = false;
    }

    @Override
    public void paint(IGraphics graphics) {
        if (!(this.valid && this.pointArray != null || this.values == null || this.style == LineStyle.Invisible)) {
            this.pointArray = new Point[this.values.length];
            int i = 0;
            while (i < this.values.length) {
                Date date = (Date)this.values[i].getAdapter(Date.class);
                Number value = (Number)this.values[i].getAdapter(Number.class);
                this.pointArray[i] = graphics.mapToPoint(date, value);
                ++i;
            }
            this.valid = true;
        }
        if (this.pointArray != null && this.style != LineStyle.Invisible) {
            switch (this.style) {
                case Dash: {
                    graphics.setLineStyle(2);
                    break;
                }
                case Dot: {
                    graphics.setLineStyle(3);
                    break;
                }
                default: {
                    graphics.setLineStyle(1);
                }
            }
            graphics.pushState();
            graphics.setForegroundColor(this.color);
            graphics.setLineWidth(this.hasFocus() ? 2 : 1);
            graphics.drawPolyline(this.pointArray);
            graphics.popState();
        }
    }

    @Override
    public void paintScale(Graphics graphics) {
    }

    @Override
    public boolean containsPoint(int x, int y) {
        if (this.pointArray != null) {
            if (y == -1) {
                return true;
            }
            return PixelTools.isPointOnLine(x, y, this.pointArray);
        }
        return false;
    }

    @Override
    public IDataSeries getDataSeries() {
        return this.dataSeries;
    }

    @Override
    public String getToolTip() {
        if (this.dataSeries.getLast() != null) {
            IOHLC ohlc = (IOHLC)this.dataSeries.getLast().getAdapter(IOHLC.class);
            return String.valueOf(this.dateFormat.format(ohlc.getDate())) + " O:" + this.numberFormat.format(ohlc.getOpen()) + " H:" + this.numberFormat.format(ohlc.getHigh()) + " L:" + this.numberFormat.format(ohlc.getLow()) + " C:" + this.numberFormat.format(ohlc.getHigh());
        }
        return this.dataSeries.getName();
    }

    @Override
    public String getToolTip(int x, int y) {
        block6: {
            if (this.pointArray == null) break block6;
            if (y == -1) {
                int i = 0;
                while (i < this.pointArray.length) {
                    if (x >= this.pointArray[i].x - this.width / 2 && x <= this.pointArray[i].x + this.width / 2) {
                        return this.getTooltipAt(i);
                    }
                    ++i;
                }
            } else {
                int i = 1;
                while (i < this.pointArray.length) {
                    if (PixelTools.isPointOnLine(x, y, this.pointArray[i - 1].x, this.pointArray[i - 1].y, this.pointArray[i].x, this.pointArray[i].y)) {
                        return this.getTooltipAt(i - 1);
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    String getTooltipAt(int index) {
        IOHLC ohlc = (IOHLC)this.values[index].getAdapter(IOHLC.class);
        return String.valueOf(this.dataSeries.getName()) + "\r\nD:" + this.dateFormat.format(ohlc.getDate()) + "\r\nO:" + this.numberFormat.format(ohlc.getOpen()) + "\r\nH:" + this.numberFormat.format(ohlc.getHigh()) + "\r\nL:" + this.numberFormat.format(ohlc.getLow()) + "\r\nC:" + this.numberFormat.format(ohlc.getHigh());
    }

    @Override
    public void accept(IChartObjectVisitor visitor) {
        visitor.visit(this);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ISummaryBarDecorator.class)) {
            return this;
        }
        return null;
    }

    @Override
    public void createDecorator(Composite parent) {
        IAdaptable[] values = this.dataSeries.getValues();
        IOHLC ohlc = (IOHLC)(values.length > 0 ? values[values.length - 1].getAdapter(IOHLC.class) : null);
        IOHLC previousOhlc = (IOHLC)(values.length > 1 ? values[values.length - 2].getAdapter(IOHLC.class) : null);
        this.dateItem = new SummaryDateItem(parent, 32);
        this.dateItem.setDate(ohlc != null ? ohlc.getDate() : null);
        this.ohlcItem = new SummaryOHLCItem(parent, 0);
        this.ohlcItem.setOHLC(ohlc, previousOhlc);
    }

    @Override
    public void updateDecorator(int x, int y) {
        if (this.pointArray != null) {
            IOHLC ohlc = null;
            IOHLC previousOhlc = null;
            if (y == -1) {
                int i = 0;
                while (i < this.pointArray.length) {
                    if (x >= this.pointArray[i].x - this.width / 2 && x <= this.pointArray[i].x + this.width / 2) {
                        ohlc = (IOHLC)this.values[i].getAdapter(IOHLC.class);
                        if (i > 0) {
                            previousOhlc = (IOHLC)this.values[i - 1].getAdapter(IOHLC.class);
                        }
                    }
                    ++i;
                }
            } else {
                int i = 1;
                while (i < this.pointArray.length) {
                    if (PixelTools.isPointOnLine(x, y, this.pointArray[i - 1].x, this.pointArray[i - 1].y, this.pointArray[i].x, this.pointArray[i].y)) {
                        ohlc = (IOHLC)this.values[i - 1].getAdapter(IOHLC.class);
                        if (i > 1) {
                            previousOhlc = (IOHLC)this.values[i - 2].getAdapter(IOHLC.class);
                        }
                    }
                    ++i;
                }
            }
            if (ohlc != null) {
                this.dateItem.setDate(ohlc.getDate());
                this.ohlcItem.setOHLC(ohlc, previousOhlc);
            }
        }
    }

    public static enum LineStyle {
        Solid,
        Dot,
        Dash,
        Invisible;

    }
}

