/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.ui.charts.OHLCField;

public class Util {
    public static RGB blend(RGB c1, RGB c2, int ratio) {
        int r = Util.blend(c1.red, c2.red, ratio);
        int g = Util.blend(c1.green, c2.green, ratio);
        int b = Util.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    private static int blend(int v1, int v2, int ratio) {
        return (ratio * v1 + (100 - ratio) * v2) / 100;
    }

    public static void paintImage(PaintEvent event, Image image) {
        if (image != null && !image.isDisposed()) {
            int height;
            Rectangle bounds = image.getBounds();
            int width = event.width;
            if (event.x + width > bounds.width) {
                width = bounds.width - event.x;
            }
            if (event.y + (height = event.height) > bounds.height) {
                height = bounds.height - event.y;
            }
            if (width != 0 && height != 0) {
                event.gc.drawImage(image, event.x, event.y, width, height, event.x, event.y, width, height);
            }
        }
    }

    public static double[] getValuesForField(IAdaptable[] values, OHLCField field) {
        double[] inReal = new double[values.length];
        switch (field) {
            case Open: {
                int i = 0;
                while (i < values.length) {
                    IOHLC ohlc = (IOHLC)values[i].getAdapter(IOHLC.class);
                    if (ohlc != null) {
                        inReal[i] = ohlc.getOpen();
                    } else {
                        Number number = (Number)values[i].getAdapter(Number.class);
                        inReal[i] = number.doubleValue();
                    }
                    ++i;
                }
                break;
            }
            case High: {
                int i = 0;
                while (i < values.length) {
                    IOHLC ohlc = (IOHLC)values[i].getAdapter(IOHLC.class);
                    if (ohlc != null) {
                        inReal[i] = ohlc.getHigh();
                    } else {
                        Number number = (Number)values[i].getAdapter(Number.class);
                        inReal[i] = number.doubleValue();
                    }
                    ++i;
                }
                break;
            }
            case Low: {
                int i = 0;
                while (i < values.length) {
                    IOHLC ohlc = (IOHLC)values[i].getAdapter(IOHLC.class);
                    if (ohlc != null) {
                        inReal[i] = ohlc.getLow();
                    } else {
                        Number number = (Number)values[i].getAdapter(Number.class);
                        inReal[i] = number.doubleValue();
                    }
                    ++i;
                }
                break;
            }
            case Close: {
                int i = 0;
                while (i < values.length) {
                    IOHLC ohlc = (IOHLC)values[i].getAdapter(IOHLC.class);
                    if (ohlc != null) {
                        inReal[i] = ohlc.getClose();
                    } else {
                        Number number = (Number)values[i].getAdapter(Number.class);
                        inReal[i] = number.doubleValue();
                    }
                    ++i;
                }
                break;
            }
        }
        return inReal;
    }
}

