/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipsetrader.core.ILauncher;
import org.eclipsetrader.ui.internal.LauncherStartAction;
import org.eclipsetrader.ui.internal.Messages;
import org.eclipsetrader.ui.internal.StartAllAction;
import org.eclipsetrader.ui.internal.UIActivator;

public class StartFeedAction
implements IWorkbenchWindowActionDelegate,
IWorkbenchWindowPulldownDelegate2 {
    public static final String LAUNCHERS_EXTENSION_ID = "org.eclipsetrader.core.launchers";
    private Menu menubarMenu;
    private Menu toolbarMenu;

    public void init(IWorkbenchWindow window) {
    }

    public void dispose() {
        if (this.menubarMenu != null) {
            this.menubarMenu.dispose();
            this.menubarMenu = null;
        }
        if (this.toolbarMenu != null) {
            this.toolbarMenu.dispose();
            this.toolbarMenu = null;
        }
    }

    public Menu getMenu(Menu parent) {
        if (this.menubarMenu != null) {
            this.menubarMenu.dispose();
        }
        this.menubarMenu = new Menu(parent);
        this.initMenu(this.menubarMenu);
        return this.menubarMenu;
    }

    public Menu getMenu(Control parent) {
        if (this.toolbarMenu != null) {
            this.toolbarMenu.dispose();
        }
        this.toolbarMenu = new Menu(parent);
        this.initMenu(this.toolbarMenu);
        return this.toolbarMenu;
    }

    public void run(IAction action) {
        Job job = new Job(Messages.StartFeedAction_FeedStartup){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(this.getName(), -1);
                try {
                    boolean startAll = UIActivator.getDefault().getPreferenceStore().getBoolean("RUN_ALL_LAUNCHERS");
                    HashSet<String> set = new HashSet<String>(Arrays.asList(UIActivator.getDefault().getPreferenceStore().getString("RUN_LAUNCHERS").split(";")));
                    ILauncher[] launchers = StartFeedAction.this.getLaunchers();
                    int i = 0;
                    while (i < launchers.length) {
                        if (startAll || set.contains(launchers[i].getId())) {
                            try {
                                launchers[i].launch(monitor);
                            }
                            catch (Exception e) {
                                Status status = new Status(4, "org.eclipsetrader.ui", 0, "Error launching " + launchers[i].getId(), (Throwable)e);
                                UIActivator.getDefault().getLog().log((IStatus)status);
                            }
                        }
                        ++i;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private void initMenu(Menu menu) {
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu m = (Menu)e.widget;
                MenuItem[] items = m.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                StartFeedAction.this.fillMenu(m);
            }
        });
    }

    protected void fillMenu(Menu menu) {
        ActionContributionItem item = new ActionContributionItem((IAction)new StartAllAction());
        item.fill(menu, -1);
        new MenuItem(menu, 2);
        ILauncher[] launchers = this.getLaunchers();
        int i = 0;
        while (i < launchers.length) {
            item = new ActionContributionItem((IAction)new LauncherStartAction(launchers[i]));
            item.fill(menu, -1);
            ++i;
        }
    }

    ILauncher[] getLaunchers() {
        ArrayList<ILauncher> list = new ArrayList<ILauncher>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(LAUNCHERS_EXTENSION_ID);
        if (extensionPoint != null) {
            IConfigurationElement[] configElements = extensionPoint.getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                String id = configElements[j].getAttribute("id");
                try {
                    ILauncher launcher = (ILauncher)configElements[j].createExecutableExtension("class");
                    if (launcher != null) {
                        list.add(launcher);
                    }
                }
                catch (Exception e) {
                    Status status = new Status(4, "org.eclipsetrader.ui", 0, "Error launching " + id, (Throwable)e);
                    UIActivator.getDefault().getLog().log((IStatus)status);
                }
                ++j;
            }
        }
        Collections.sort(list, new Comparator<ILauncher>(){

            @Override
            public int compare(ILauncher o1, ILauncher o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        return list.toArray(new ILauncher[list.size()]);
    }
}

