/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.ats;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import org.eclipsetrader.core.ats.Report;
import org.eclipsetrader.core.ats.simulation.SimulationReport;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.charts.OHLCDataSeries;
import org.eclipsetrader.core.feed.IBar;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.core.feed.OHLC;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.trading.IOrder;
import org.eclipsetrader.core.trading.IOrderSide;
import org.eclipsetrader.core.trading.IStockTransaction;
import org.eclipsetrader.core.trading.ITransaction;
import org.eclipsetrader.ui.Util;
import org.eclipsetrader.ui.charts.BarChart;
import org.eclipsetrader.ui.charts.BaseChartViewer;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.LineChart;
import org.eclipsetrader.ui.internal.ats.Messages;
import org.eclipsetrader.ui.internal.charts.VOLUME;

public class ReportViewPart
extends ViewPart {
    public static final String VIEW_ID = "org.eclipsetrader.ui.ats.views.report";
    private BaseChartViewer equityChartViewer;
    private TableViewer tradesViewer;

    public void createPartControl(Composite parent) {
        this.createSummaryPage(parent);
    }

    private Control createSummaryPage(Composite parent) {
        SashForm content = new SashForm(parent, 524800);
        GC gc = new GC((Drawable)content);
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        Composite composite = new Composite((Composite)content, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(composite, 0);
        label.setText(Messages.ReportViewPart_Performance);
        this.equityChartViewer = new BaseChartViewer(composite, 2048);
        this.equityChartViewer.setFillAvailableSpace(true);
        this.equityChartViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        composite = new Composite((Composite)content, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        label = new Label(composite, 0);
        label.setText(Messages.ReportViewPart_Trades);
        this.tradesViewer = new TableViewer(composite, 67586);
        this.tradesViewer.getTable().setHeaderVisible(true);
        this.tradesViewer.getTable().setLinesVisible(false);
        this.tradesViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        content.setWeights(new int[]{75, 25});
        final DateFormat dateFormat = Util.getDateFormat();
        final NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setGroupingUsed(true);
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        final NumberFormat priceNumberFormat = NumberFormat.getInstance();
        priceNumberFormat.setGroupingUsed(false);
        priceNumberFormat.setMinimumFractionDigits(1);
        priceNumberFormat.setMaximumFractionDigits(4);
        TableViewerColumn vewerColumn = new TableViewerColumn(this.tradesViewer, 0);
        vewerColumn.getColumn().setText(Messages.ReportViewPart_DateTime);
        vewerColumn.getColumn().setWidth(Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)60));
        vewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                ITransaction transaction = (ITransaction)cell.getElement();
                cell.setText(dateFormat.format(transaction.getOrder().getDate()));
            }
        });
        vewerColumn = new TableViewerColumn(this.tradesViewer, 0);
        vewerColumn.getColumn().setText(Messages.ReportViewPart_Instrument);
        vewerColumn.getColumn().setWidth(Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)150));
        vewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                IOrder order = ((ITransaction)cell.getElement()).getOrder();
                if (order != null) {
                    cell.setText(order.getSecurity().getName());
                }
            }
        });
        vewerColumn = new TableViewerColumn(this.tradesViewer, 0);
        vewerColumn.getColumn().setText(Messages.ReportViewPart_Side);
        vewerColumn.getColumn().setWidth(Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)50));
        vewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                IOrder order = ((ITransaction)cell.getElement()).getOrder();
                if (order != null) {
                    cell.setText(order.getSide().toString());
                }
            }
        });
        vewerColumn = new TableViewerColumn(this.tradesViewer, 131072);
        vewerColumn.getColumn().setText(Messages.ReportViewPart_Qty);
        vewerColumn.getColumn().setWidth(Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)60));
        vewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                ITransaction transaction = (ITransaction)cell.getElement();
                if (transaction instanceof IStockTransaction) {
                    cell.setText(String.valueOf(((IStockTransaction)transaction).getFilledQuantity()));
                }
            }
        });
        vewerColumn = new TableViewerColumn(this.tradesViewer, 131072);
        vewerColumn.getColumn().setText(Messages.ReportViewPart_AvgPrice);
        vewerColumn.getColumn().setWidth(Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)60));
        vewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                ITransaction transaction = (ITransaction)cell.getElement();
                if (transaction instanceof IStockTransaction) {
                    cell.setText(priceNumberFormat.format(((IStockTransaction)transaction).getAveragePrice()));
                }
            }
        });
        vewerColumn = new TableViewerColumn(this.tradesViewer, 131072);
        vewerColumn.getColumn().setText(Messages.ReportViewPart_Amount);
        vewerColumn.getColumn().setWidth(Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)60));
        vewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                ITransaction transaction = (ITransaction)cell.getElement();
                IOrder order = transaction.getOrder();
                double amount = transaction.getAmount().getAmount();
                if (order != null) {
                    cell.setText(numberFormat.format(order.getSide() == IOrderSide.Buy ? -amount : amount));
                } else {
                    cell.setText(numberFormat.format(amount));
                }
            }
        });
        vewerColumn = new TableViewerColumn(this.tradesViewer, 0);
        vewerColumn.getColumn().setText(Messages.ReportViewPart_Message);
        vewerColumn.getColumn().setWidth(Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)100));
        vewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                IOrder order = ((ITransaction)cell.getElement()).getOrder();
                if (order != null && order.getReference() != null) {
                    cell.setText(order.getReference());
                }
            }
        });
        this.tradesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        return content;
    }

    private Control createSecurityPage(Composite parent, ISecurity security, List<IBar> bars) {
        BaseChartViewer chartViewer = new BaseChartViewer(parent, 0);
        chartViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        ArrayList<OHLC> list = new ArrayList<OHLC>();
        for (IBar bar : bars) {
            list.add(new OHLC(bar.getDate(), bar.getOpen(), bar.getHigh(), bar.getLow(), bar.getClose(), bar.getVolume()));
        }
        OHLCDataSeries dataSeries = new OHLCDataSeries(security.getName(), list.toArray(new IOHLC[list.size()]), null);
        chartViewer.setInput(new IChartObject[][]{{new BarChart((IDataSeries)dataSeries)}, {new VOLUME().createObject((IDataSeries)dataSeries)}});
        return chartViewer.getControl();
    }

    public void setFocus() {
        this.equityChartViewer.getControl().setFocus();
    }

    public void setReport(Report report) {
        String title = NLS.bind((String)Messages.ReportViewPart_Report1, (Object[])new Object[]{report.getStrategy().getName()});
        if (report instanceof SimulationReport) {
            SimulationReport simulationReport = (SimulationReport)report;
            DateFormat dateFormat = Util.getDateFormat();
            title = NLS.bind((String)Messages.ReportViewPart_Report2, (Object[])new Object[]{report.getStrategy().getName(), dateFormat.format(simulationReport.getBegin()), dateFormat.format(simulationReport.getEnd())});
        }
        this.setPartName(title);
        LineChart lineChart = new LineChart((IDataSeries)report.getEquityData(), LineChart.LineStyle.Solid, new RGB(0, 0, 224));
        this.equityChartViewer.setInput(new IChartObject[][]{{lineChart}});
        this.equityChartViewer.setSummaryVisible(false);
        this.tradesViewer.setInput((Object)report.getTradesData());
    }
}

