/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.ats;

import java.util.Date;
import java.util.UUID;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipsetrader.core.ats.IScriptStrategy;
import org.eclipsetrader.core.ats.Report;
import org.eclipsetrader.core.ats.simulation.SimulationRunner;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.ats.Messages;
import org.eclipsetrader.ui.internal.ats.ReportViewPart;
import org.eclipsetrader.ui.internal.ats.SimulationParametersDialog;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class RunSimulationHandler
extends AbstractHandler {
    private IWorkbenchSite site;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        this.site = HandlerUtil.getActiveSite((ExecutionEvent)event);
        if (selection != null && !selection.isEmpty()) {
            for (Object target : selection) {
                if (target instanceof IAdaptable) {
                    target = ((IAdaptable)target).getAdapter(IScriptStrategy.class);
                }
                if (!(target instanceof IScriptStrategy)) continue;
                IScriptStrategy strategy = (IScriptStrategy)target;
                SimulationParametersDialog dlg = new SimulationParametersDialog(this.site.getShell());
                if (dlg.open() != 0) continue;
                Date begin = dlg.getBeginDate();
                Date end = dlg.getEndDate();
                this.scheduleJob(strategy, begin, end);
            }
        }
        return null;
    }

    private void scheduleJob(final IScriptStrategy strategy, final Date begin, final Date end) {
        String title = NLS.bind((String)Messages.RunSimulationHandler_Simulation, (Object[])new Object[]{strategy.getName()});
        Job job = new Job(title){

            protected IStatus run(IProgressMonitor monitor) {
                BundleContext bundleContext = UIActivator.getDefault().getBundle().getBundleContext();
                ServiceReference serviceReference = bundleContext.getServiceReference(IRepositoryService.class);
                IRepositoryService repositoryService = (IRepositoryService)bundleContext.getService(serviceReference);
                try {
                    try {
                        final SimulationRunner runner = new SimulationRunner(repositoryService, strategy, begin, end);
                        runner.runWithProgress(monitor);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    ReportViewPart viewPart = (ReportViewPart)RunSimulationHandler.this.site.getPage().showView("org.eclipsetrader.ui.ats.views.report", UUID.randomUUID().toString(), 1);
                                    viewPart.setReport((Report)runner.getReport());
                                }
                                catch (PartInitException e) {
                                    Status status = new Status(4, "org.eclipsetrader.ui", 0, "Error opening report view", (Throwable)e);
                                    UIActivator.log((IStatus)status);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        Status status;
                        Status status2 = status = new Status(4, "org.eclipsetrader.ui", "Error running simulation", (Throwable)e);
                        bundleContext.ungetService(serviceReference);
                        return status2;
                    }
                }
                finally {
                    bundleContext.ungetService(serviceReference);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }
}

