/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.ats;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IRepositoryRunnable;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.eclipsetrader.ui.internal.UIActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class SaveAdaptableHelper {
    public static IStatus save(IAdaptable adaptableElement) {
        return SaveAdaptableHelper.save(adaptableElement, null);
    }

    public static IStatus save(final IAdaptable adaptableElement, final IRepository repository) {
        final AtomicReference result = new AtomicReference();
        BundleContext context = UIActivator.getDefault().getBundle().getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(IRepositoryService.class.getName());
        if (serviceReference != null) {
            final IRepositoryService service = (IRepositoryService)context.getService(serviceReference);
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    IStatus status = service.runInService(new IRepositoryRunnable(){

                        public IStatus run(IProgressMonitor monitor) throws Exception {
                            IStoreObject storeObject = (IStoreObject)adaptableElement.getAdapter(IStoreObject.class);
                            if (repository != null && repository != storeObject.getStore().getRepository()) {
                                service.moveAdaptable(new IAdaptable[]{adaptableElement}, repository);
                            } else {
                                service.saveAdaptable(new IAdaptable[]{adaptableElement});
                            }
                            return Status.OK_STATUS;
                        }
                    }, null);
                    result.set(status);
                }
            });
        }
        return (IStatus)result.get();
    }
}

