/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.ats;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipsetrader.ui.Util;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.ats.Messages;

public class SimulationParametersDialog
extends Dialog {
    public static final String K_BEGIN_DATE = "BEGIN_DATE";
    public static final String K_END_DATE = "END_DATE";
    public static final String TODAY = Messages.SimulationParametersDialog_Today;
    private CDateTime begin;
    private CDateTime end;
    private Date beginDate;
    private Date endDate;
    private final IDialogSettings rootDialogSettings = UIActivator.getDefault().getDialogSettings();

    public SimulationParametersDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.SimulationParametersDialog_RunSimulation);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        SimulationParametersDialog.applyDialogFont((Control)composite);
        Label label = new Label(composite, 0);
        label.setText(Messages.SimulationParametersDialog_Begin);
        this.begin = new CDateTime(composite, 34603011);
        this.begin.setPattern(Util.getDateFormatPattern());
        this.begin.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels("gtk".equals(SWT.getPlatform()) ? 80 : 65), -1));
        label = new Label(composite, 0);
        label.setText(Messages.SimulationParametersDialog_End);
        this.end = new CDateTime(composite, 34603011);
        this.end.setPattern(Util.getDateFormatPattern());
        this.end.setNullText(TODAY);
        this.end.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels("gtk".equals(SWT.getPlatform()) ? 80 : 65), -1));
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -30);
        this.begin.setSelection(calendar.getTime());
        IDialogSettings dialogSettings = this.rootDialogSettings.getSection(((Object)((Object)this)).getClass().getName());
        if (dialogSettings != null) {
            if (dialogSettings.get(K_BEGIN_DATE) != null) {
                calendar.setTimeInMillis(dialogSettings.getLong(K_BEGIN_DATE));
                this.begin.setSelection(calendar.getTime());
            }
            if (dialogSettings.get(K_END_DATE) != null && !TODAY.equals(dialogSettings.get(K_END_DATE))) {
                calendar.setTimeInMillis(dialogSettings.getLong(K_END_DATE));
                this.end.setSelection(calendar.getTime());
            }
        }
        return composite;
    }

    protected void okPressed() {
        this.beginDate = this.begin.getSelection();
        this.endDate = this.end.getSelection();
        IDialogSettings dialogSettings = this.rootDialogSettings.getSection(((Object)((Object)this)).getClass().getName());
        if (dialogSettings == null) {
            dialogSettings = this.rootDialogSettings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        dialogSettings.put(K_BEGIN_DATE, this.beginDate.getTime());
        if (this.endDate == null) {
            dialogSettings.put(K_END_DATE, TODAY);
            this.endDate = Calendar.getInstance().getTime();
        } else {
            dialogSettings.put(K_END_DATE, this.endDate.getTime());
        }
        super.okPressed();
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }
}

