/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.ats;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.ui.internal.ats.Messages;

public class TimeSpanDialog
extends Dialog {
    private ComboViewer units;
    private Spinner value;
    private TimeSpan selection;

    public TimeSpanDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TimeSpanDialog_TimeSpan);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        TimeSpanDialog.applyDialogFont((Control)composite);
        Label label = new Label(composite, 0);
        label.setText(Messages.TimeSpanDialog_Value);
        this.value = new Spinner(composite, 2048);
        this.value.setValues(1, 1, 9999, 0, 1, 10);
        this.units = new ComboViewer(composite, 12);
        this.units.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.units.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.units.setSorter(new ViewerSorter());
        this.units.setInput((Object)new Object[]{TimeSpan.Units.Minutes, TimeSpan.Units.Days});
        this.units.setSelection((ISelection)new StructuredSelection((Object)TimeSpan.Units.Minutes));
        this.units.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TimeSpan.Units units = (TimeSpan.Units)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (units == TimeSpan.Units.Days) {
                    TimeSpanDialog.this.value.setValues(1, 1, 1, 0, 1, 10);
                } else {
                    TimeSpanDialog.this.value.setValues(1, 1, 9999, 0, 1, 10);
                }
            }
        });
        return composite;
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.units.getSelection();
        TimeSpan.Units unit = (TimeSpan.Units)selection.getFirstElement();
        this.selection = new TimeSpan(unit, this.value.getSelection());
        super.okPressed();
    }

    public TimeSpan getSelection() {
        return this.selection;
    }
}

