/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.ats;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipsetrader.core.views.IDataProvider;
import org.eclipsetrader.core.views.IDataProviderFactory;

public class ViewColumn {
    public static final String PROP_NAME = "name";
    private final IDataProviderFactory factory;
    private final IDataProvider dataProvider;
    private String name;
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public ViewColumn(IDataProviderFactory factory) {
        this.factory = factory;
        this.dataProvider = factory.createProvider();
    }

    public ViewColumn(String name, IDataProviderFactory factory) {
        this.factory = factory;
        this.dataProvider = factory.createProvider();
        this.name = name != null ? name : factory.getName();
    }

    public String getId() {
        return this.factory.getId();
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.changeSupport.firePropertyChange(PROP_NAME, this.name, this.name);
    }

    public IDataProviderFactory getDataProviderFactory() {
        return this.factory;
    }

    public IDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ViewColumn)) {
            return false;
        }
        ViewColumn other = (ViewColumn)obj;
        return this.factory.getId().equals(other.factory.getId());
    }
}

