/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.ats;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipsetrader.ui.internal.ats.ViewItem;

public class ViewerObservableMap
implements IObservableMap {
    private final Realm realm;
    private final String key;
    private final WritableMap delegate;
    private final ISetChangeListener changeListener = new ISetChangeListener(){

        public void handleSetChange(SetChangeEvent event) {
            ViewItem viewItem;
            HashMap additions = new HashMap();
            for (Object o : event.diff.getAdditions()) {
                viewItem = (ViewItem)o;
                ViewerObservableMap.this.delegate.put(o, viewItem.getValue(ViewerObservableMap.this.key));
                viewItem.addPropertyChangeListener(ViewerObservableMap.this.key, ViewerObservableMap.this.propertyChangeListener);
            }
            for (Object o : event.diff.getRemovals()) {
                viewItem = (ViewItem)o;
                ViewerObservableMap.this.delegate.remove((Object)viewItem);
                viewItem.removePropertyChangeListener(ViewerObservableMap.this.key, ViewerObservableMap.this.propertyChangeListener);
            }
            ViewerObservableMap.this.delegate.putAll(additions);
        }
    };
    private final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            if (!ViewerObservableMap.this.key.equals(evt.getPropertyName())) {
                return;
            }
            ViewerObservableMap.this.realm.exec(new Runnable(){

                @Override
                public void run() {
                    ViewerObservableMap.this.delegate.put(evt.getSource(), evt.getNewValue());
                }
            });
        }
    };

    public ViewerObservableMap(IObservableSet knownElements, String key) {
        this(Realm.getDefault(), knownElements, key);
    }

    public ViewerObservableMap(Realm realm, IObservableSet knownElements, String key) {
        this.realm = realm;
        this.key = key;
        this.delegate = new WritableMap(realm);
        for (Object o : knownElements) {
            ViewItem viewItem = (ViewItem)o;
            this.delegate.put(o, viewItem.getValue(key));
            viewItem.addPropertyChangeListener(key, this.propertyChangeListener);
        }
        knownElements.addSetChangeListener(this.changeListener);
    }

    public String getKey() {
        return this.key;
    }

    public void putAll(Map m) {
    }

    public void clear() {
    }

    public Realm getRealm() {
        return this.realm;
    }

    public void addChangeListener(IChangeListener listener) {
        this.delegate.addChangeListener(listener);
    }

    public void removeChangeListener(IChangeListener listener) {
        this.delegate.removeChangeListener(listener);
    }

    public void addStaleListener(IStaleListener listener) {
        this.delegate.addStaleListener(listener);
    }

    public void removeStaleListener(IStaleListener listener) {
        this.delegate.removeStaleListener(listener);
    }

    public boolean isStale() {
        return this.delegate.isStale();
    }

    public void addDisposeListener(IDisposeListener listener) {
        this.delegate.addDisposeListener(listener);
    }

    public void removeDisposeListener(IDisposeListener listener) {
        this.delegate.removeDisposeListener(listener);
    }

    public boolean isDisposed() {
        return this.delegate.isDisposed();
    }

    public void dispose() {
        this.delegate.dispose();
    }

    public Object getKeyType() {
        return null;
    }

    public Object getValueType() {
        return null;
    }

    public void addMapChangeListener(IMapChangeListener listener) {
        this.delegate.addMapChangeListener(listener);
    }

    public void removeMapChangeListener(IMapChangeListener listener) {
        this.delegate.removeMapChangeListener(listener);
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    public Object get(Object key) {
        return this.delegate.get(key);
    }

    public Object put(Object key, Object value) {
        return this.delegate.put(key, value);
    }

    public Object remove(Object key) {
        return this.delegate.remove(key);
    }

    public Set keySet() {
        return this.delegate.keySet();
    }

    public Collection values() {
        return this.delegate.values();
    }

    public Set entrySet() {
        return this.delegate.entrySet();
    }
}

