/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.ats.explorer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipsetrader.core.IScript;
import org.eclipsetrader.core.ats.IScriptStrategy;
import org.eclipsetrader.core.ats.IStrategy;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.repositories.IRepositoryChangeListener;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.eclipsetrader.core.repositories.RepositoryChangeEvent;
import org.eclipsetrader.core.repositories.RepositoryResourceDelta;
import org.eclipsetrader.ui.internal.ats.explorer.ExplorerViewItem;
import org.eclipsetrader.ui.internal.ats.explorer.ExplorerViewItemVisitor;
import org.eclipsetrader.ui.internal.ats.explorer.InstrumentItem;
import org.eclipsetrader.ui.internal.ats.explorer.MainScriptItem;
import org.eclipsetrader.ui.internal.ats.explorer.Messages;
import org.eclipsetrader.ui.internal.ats.explorer.ScriptItem;
import org.eclipsetrader.ui.internal.ats.explorer.StrategyItem;

public class ExplorerViewModel
extends TreeStructureAdvisor
implements IObservableFactory {
    private final IRepositoryService repositoryService;
    private final List<ExplorerViewItem> list = new ArrayList<ExplorerViewItem>();
    private final WritableList root = new WritableList(this.list, ExplorerViewItem.class);
    private final IRepositoryChangeListener repositoryChangeListener = new IRepositoryChangeListener(){

        public void repositoryResourceChanged(RepositoryChangeEvent event) {
            RepositoryResourceDelta[] repositoryResourceDeltaArray = event.getDeltas();
            int n = repositoryResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                RepositoryResourceDelta delta = repositoryResourceDeltaArray[n2];
                if (delta.getResource() instanceof IStrategy) {
                    ExplorerViewItem viewItem;
                    IStrategy resource = (IStrategy)delta.getResource();
                    if ((delta.getKind() & 4) != 0) {
                        viewItem = (StrategyItem)ExplorerViewModel.this.getViewItemFor(resource);
                        if (viewItem != null) {
                            ((StrategyItem)viewItem).update();
                        }
                    } else if ((delta.getKind() & 1) != 0) {
                        ExplorerViewModel.this.root.add((Object)new StrategyItem(resource));
                    } else if ((delta.getKind() & 2) != 0 && (viewItem = ExplorerViewModel.this.getViewItemFor(resource)) != null) {
                        if (viewItem.getParent() == null) {
                            ExplorerViewModel.this.root.remove((Object)viewItem);
                        } else {
                            viewItem.getParent().getItems().remove((Object)viewItem);
                        }
                    }
                }
                ++n2;
            }
        }
    };

    public ExplorerViewModel(IRepositoryService repositoryService) {
        this.repositoryService = repositoryService;
        IStoreObject[] iStoreObjectArray = repositoryService.getAllObjects();
        int n = iStoreObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStoreObject object = iStoreObjectArray[n2];
            if (object instanceof IStrategy) {
                this.root.add((Object)new StrategyItem((IStrategy)object));
            }
            ++n2;
        }
        repositoryService.addRepositoryResourceListener(this.repositoryChangeListener);
    }

    public WritableList getRoot() {
        return this.root;
    }

    public void dispose() {
        this.repositoryService.removeRepositoryResourceListener(this.repositoryChangeListener);
        this.root.clear();
        this.root.dispose();
    }

    public IObservable createObservable(Object target) {
        ObservableList list;
        if (target == this) {
            return Observables.unmodifiableObservableList((IObservableList)this.root);
        }
        if (target instanceof ExplorerViewItem && (list = ((ExplorerViewItem)target).getItems()) != null) {
            return Observables.unmodifiableObservableList((IObservableList)list);
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof ExplorerViewItem) {
            return ((ExplorerViewItem)element).getParent();
        }
        return null;
    }

    public Boolean hasChildren(Object element) {
        if (element == this) {
            if (this.root.size() != 0) {
                return true;
            }
            return false;
        }
        if (element instanceof ExplorerViewItem) {
            return ((ExplorerViewItem)element).hasChildren();
        }
        return false;
    }

    public ExplorerViewItem getViewItemFor(final Object target) {
        final AtomicReference result = new AtomicReference();
        ExplorerViewItemVisitor visitor = new ExplorerViewItemVisitor(){

            @Override
            public void visit(ExplorerViewItem viewItem) {
                if (viewItem.getAdapter(target.getClass()) == target) {
                    result.set(viewItem);
                } else if (viewItem.getItems() != null) {
                    for (Object childItem : viewItem.getItems()) {
                        ((ExplorerViewItem)childItem).accept(this);
                        if (result.get() != null) break;
                    }
                }
            }
        };
        for (ExplorerViewItem viewItem : this.list) {
            viewItem.accept(visitor);
            if (result.get() != null) break;
        }
        return (ExplorerViewItem)result.get();
    }

    public static class InstrumentRootItem
    implements ExplorerViewItem {
        private final StrategyItem parent;
        private final IStrategy strategy;
        private final List<InstrumentItem> list = new ArrayList<InstrumentItem>();
        private final WritableList childs = new WritableList(this.list, InstrumentItem.class);

        public InstrumentRootItem(StrategyItem parent) {
            this.parent = parent;
            this.strategy = parent.getStrategy();
            ISecurity[] iSecurityArray = this.strategy.getInstruments();
            int n = iSecurityArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISecurity instrument = iSecurityArray[n2];
                this.childs.add((Object)new InstrumentItem(this, instrument));
                ++n2;
            }
        }

        public IStrategy getStrategy() {
            return this.strategy;
        }

        public void update() {
            List<ISecurity> currentInstruments = Arrays.asList(this.strategy.getInstruments());
            ArrayList<InstrumentItem> toAdd = new ArrayList<InstrumentItem>();
            for (ISecurity instrument : currentInstruments) {
                if (this.contains(instrument)) continue;
                toAdd.add(new InstrumentItem(this, instrument));
            }
            ArrayList<InstrumentItem> toRemove = new ArrayList<InstrumentItem>();
            for (InstrumentItem item : this.list) {
                if (currentInstruments.contains(item.getInstrument())) continue;
                toRemove.add(item);
            }
            this.childs.addAll(toAdd);
            this.childs.removeAll(toRemove);
        }

        private boolean contains(ISecurity instrument) {
            for (Object o : this.childs) {
                if (((InstrumentItem)o).getInstrument() != instrument) continue;
                return true;
            }
            return false;
        }

        @Override
        public ExplorerViewItem getParent() {
            return this.parent;
        }

        @Override
        public boolean hasChildren() {
            return this.childs.size() != 0;
        }

        @Override
        public ObservableList getItems() {
            return this.childs;
        }

        @Override
        public void accept(ExplorerViewItemVisitor visitor) {
            visitor.visit(this);
        }

        public Object getAdapter(Class adapter) {
            if (adapter.isAssignableFrom(this.strategy.getClass())) {
                return this.strategy;
            }
            if (adapter.isAssignableFrom(this.getClass())) {
                return this;
            }
            return null;
        }

        public String toString() {
            return Messages.ExplorerViewModel_Instruments;
        }
    }

    public static class ScriptRootItem
    implements ExplorerViewItem {
        private final StrategyItem parent;
        private final IScriptStrategy strategy;
        private final List<ScriptItem> list = new ArrayList<ScriptItem>();
        private final WritableList childs = new WritableList(this.list, ScriptItem.class);

        public ScriptRootItem(StrategyItem parent) {
            this.parent = parent;
            this.strategy = (IScriptStrategy)parent.getStrategy();
            this.childs.add((Object)new MainScriptItem(this));
            IScript[] iScriptArray = this.strategy.getIncludes();
            int n = iScriptArray.length;
            int n2 = 0;
            while (n2 < n) {
                IScript script = iScriptArray[n2];
                this.childs.add((Object)new ScriptItem(this, script));
                ++n2;
            }
        }

        public IStrategy getStrategy() {
            return this.strategy;
        }

        public void update() {
            List<IScript> currentScripts = Arrays.asList(this.strategy.getIncludes());
            ArrayList<ScriptItem> toAdd = new ArrayList<ScriptItem>();
            for (IScript script : currentScripts) {
                if (this.contains(script)) continue;
                toAdd.add(new ScriptItem(this, script));
            }
            ArrayList<ScriptItem> toRemove = new ArrayList<ScriptItem>();
            for (ScriptItem item : this.list.subList(1, this.list.size())) {
                if (currentScripts.contains(item.getScript())) continue;
                toRemove.add(item);
            }
            this.childs.addAll(toAdd);
            this.childs.removeAll(toRemove);
        }

        private boolean contains(IScript script) {
            for (ScriptItem item : this.list.subList(1, this.list.size())) {
                if (item.getScript() != script) continue;
                return true;
            }
            return false;
        }

        @Override
        public ExplorerViewItem getParent() {
            return this.parent;
        }

        @Override
        public boolean hasChildren() {
            return this.childs.size() != 0;
        }

        @Override
        public ObservableList getItems() {
            return this.childs;
        }

        @Override
        public void accept(ExplorerViewItemVisitor visitor) {
            visitor.visit(this);
        }

        public Object getAdapter(Class adapter) {
            if (adapter.isAssignableFrom(this.strategy.getClass())) {
                return this.strategy;
            }
            if (adapter.isAssignableFrom(this.getClass())) {
                return this;
            }
            return null;
        }

        public String toString() {
            return Messages.ExplorerViewModel_Scripts;
        }
    }
}

