/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.ats.explorer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipsetrader.core.IScript;
import org.eclipsetrader.core.ats.IStrategy;
import org.eclipsetrader.core.ats.ScriptStrategy;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.repositories.IRepositoryRunnable;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.ats.explorer.ExplorerViewItem;
import org.eclipsetrader.ui.internal.ats.explorer.ExplorerViewModel;
import org.eclipsetrader.ui.internal.ats.explorer.InstrumentItem;
import org.eclipsetrader.ui.internal.ats.explorer.MainScriptItem;
import org.eclipsetrader.ui.internal.ats.explorer.Messages;
import org.eclipsetrader.ui.internal.ats.explorer.ScriptItem;
import org.eclipsetrader.ui.internal.ats.explorer.StrategyItem;
import org.eclipsetrader.ui.navigator.RepositoryObjectTransfer;
import org.eclipsetrader.ui.navigator.SecurityObjectTransfer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ExplorerViewPart
extends ViewPart {
    public static final String VIEW_ID = "org.eclipsetrader.ui.ats.views.explorer";
    private IRepositoryService repositoryService;
    private TreeViewer viewer;
    private ExplorerViewModel model;
    private Action collapseAllAction;
    private Action expandAllAction;
    private Action deleteAction;
    private Action removeAction;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        BundleContext bundleContext = UIActivator.getDefault().getBundle().getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(IRepositoryService.class);
        this.repositoryService = (IRepositoryService)bundleContext.getService(serviceReference);
        ImageRegistry imageRegistry = UIActivator.getDefault().getImageRegistry();
        this.collapseAllAction = new Action(Messages.ExplorerViewPart_CollapseAll, imageRegistry.getDescriptor("collapseall")){

            public void run() {
                ExplorerViewPart.this.viewer.collapseAll();
            }
        };
        this.expandAllAction = new Action(Messages.ExplorerViewPart_ExpandAll, imageRegistry.getDescriptor("expandall")){

            public void run() {
                ExplorerViewPart.this.viewer.expandAll();
            }
        };
        this.deleteAction = new Action(Messages.ExplorerViewPart_Delete){

            public void run() {
                if (ExplorerViewPart.this.viewer.getSelection().isEmpty()) {
                    return;
                }
                if (!MessageDialog.openConfirm((Shell)ExplorerViewPart.this.getViewSite().getShell(), (String)ExplorerViewPart.this.getPartName(), (String)Messages.ExplorerViewPart_ConfirmDelete)) {
                    return;
                }
                ExplorerViewPart.this.doDeleteAction();
            }
        };
        this.deleteAction.setImageDescriptor(imageRegistry.getDescriptor("delete"));
        this.deleteAction.setDisabledImageDescriptor(imageRegistry.getDescriptor("delete-disabled"));
        this.deleteAction.setId(ActionFactory.DELETE.getId());
        this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.deleteAction.setEnabled(false);
        this.removeAction = new Action(Messages.ExplorerViewPart_Remove){

            public void run() {
                if (ExplorerViewPart.this.viewer.getSelection().isEmpty()) {
                    return;
                }
                if (!MessageDialog.openConfirm((Shell)ExplorerViewPart.this.getViewSite().getShell(), (String)ExplorerViewPart.this.getPartName(), (String)Messages.ExplorerViewPart_ConfirmRemove)) {
                    return;
                }
                ExplorerViewPart.this.doRemoveAction();
            }
        };
        this.removeAction.setImageDescriptor(imageRegistry.getDescriptor("remove"));
        this.removeAction.setDisabledImageDescriptor(imageRegistry.getDescriptor("remove-disabled"));
        this.removeAction.setEnabled(false);
        IToolBarManager toolBarManager = site.getActionBars().getToolBarManager();
        toolBarManager.add((IAction)this.expandAllAction);
        toolBarManager.add((IAction)this.collapseAllAction);
        site.getActionBars().setGlobalActionHandler(this.deleteAction.getId(), (IAction)this.deleteAction);
        site.getActionBars().updateActionBars();
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 65538);
        this.viewer.getTree().setHeaderVisible(false);
        this.viewer.getTree().setLinesVisible(false);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.createContextMenu();
        this.model = new ExplorerViewModel(this.repositoryService);
        this.viewer.setContentProvider((IContentProvider)new ObservableListTreeContentProvider((IObservableFactory)this.model, (TreeStructureAdvisor)this.model));
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof StrategyItem || element instanceof ExplorerViewModel.InstrumentRootItem) {
                    return UIActivator.getImageFromRegistry("folder");
                }
                if (element instanceof InstrumentItem) {
                    return UIActivator.getImageFromRegistry("instrument");
                }
                if (element instanceof ExplorerViewModel.ScriptRootItem) {
                    return UIActivator.getImageFromRegistry("script-folder");
                }
                if (element instanceof ScriptItem) {
                    return UIActivator.getImageFromRegistry("script-include");
                }
                if (element instanceof MainScriptItem) {
                    return UIActivator.getImageFromRegistry("main-script");
                }
                return super.getImage(element);
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof ScriptItem && e2 instanceof ScriptItem) {
                    return 0;
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.viewer.setInput((Object)this.model);
        this.viewer.expandAll();
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                try {
                    IHandlerService service = (IHandlerService)ExplorerViewPart.this.getSite().getService(IHandlerService.class);
                    service.executeCommand("org.eclipse.ui.file.open", null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ExplorerViewPart.this.deleteAction.setEnabled(ExplorerViewPart.this.canEnableDeleteAction(selection));
                ExplorerViewPart.this.removeAction.setEnabled(ExplorerViewPart.this.canEnableRemoveAction(selection));
            }
        });
        this.viewer.addDropSupport(3, new Transfer[]{SecurityObjectTransfer.getInstance(), RepositoryObjectTransfer.getInstance()}, (DropTargetListener)new ViewerDropAdapter((Viewer)this.viewer){

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return SecurityObjectTransfer.getInstance().isSupportedType(transferType) || RepositoryObjectTransfer.getInstance().isSupportedType(transferType);
            }

            public boolean performDrop(Object data) {
                ScriptStrategy strategy = null;
                ExplorerViewItem target = (ExplorerViewItem)this.getCurrentTarget();
                while (strategy == null && target != null) {
                    strategy = (ScriptStrategy)target.getAdapter(ScriptStrategy.class);
                    if (strategy != null) continue;
                    target = target.getParent();
                }
                if (strategy != null) {
                    final ScriptStrategy repositoryObject = strategy;
                    final IAdaptable[] contents = (IAdaptable[])data;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ExplorerViewPart.this.doAddDroppedObjects(repositoryObject, contents);
                        }
                    });
                }
                return true;
            }
        });
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#popupMenu", "popupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.add((IContributionItem)new Separator("group.new"));
                menuManager.add((IContributionItem)new GroupMarker("group.goto"));
                menuManager.add((IContributionItem)new Separator("group.open"));
                menuManager.add((IContributionItem)new GroupMarker("group.openWith"));
                menuManager.add((IContributionItem)new Separator("group.trade"));
                menuManager.add((IContributionItem)new GroupMarker("group.tradeWith"));
                menuManager.add((IContributionItem)new Separator("group.show"));
                menuManager.add((IContributionItem)new Separator("group.edit"));
                menuManager.add((IContributionItem)new GroupMarker("group.reorganize"));
                menuManager.add((IContributionItem)new GroupMarker("group.port"));
                menuManager.add((IContributionItem)new Separator("group.generate"));
                menuManager.add((IContributionItem)new Separator("group.search"));
                menuManager.add((IContributionItem)new Separator("group.build"));
                menuManager.add((IContributionItem)new Separator("additions"));
                menuManager.add((IContributionItem)new Separator("group.properties"));
                menuManager.appendToGroup("group.show", (IAction)new Action(Messages.ExplorerViewPart_ExpandAll){

                    public void run() {
                        IStructuredSelection selection = (IStructuredSelection)ExplorerViewPart.this.viewer.getSelection();
                        Iterator iter = selection.iterator();
                        while (iter.hasNext()) {
                            ExplorerViewPart.this.viewer.expandToLevel(iter.next(), -1);
                        }
                    }
                });
                menuManager.appendToGroup("group.reorganize", (IAction)ExplorerViewPart.this.removeAction);
                menuManager.appendToGroup("group.reorganize", (IAction)ExplorerViewPart.this.deleteAction);
            }
        });
        this.viewer.getControl().setMenu(menuMgr.createContextMenu(this.viewer.getControl()));
        this.getSite().registerContextMenu(menuMgr, this.getSite().getSelectionProvider());
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        BundleContext bundleContext = UIActivator.getDefault().getBundle().getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(IRepositoryService.class);
        if (serviceReference != null && this.repositoryService != null) {
            bundleContext.ungetService(serviceReference);
        }
        this.model.dispose();
        super.dispose();
    }

    private void doDeleteAction() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (Object object : selection.toList()) {
            if (!(object instanceof StrategyItem)) continue;
            final IStrategy repositoryObject = ((StrategyItem)object).getStrategy();
            this.repositoryService.runInService(new IRepositoryRunnable(){

                public IStatus run(IProgressMonitor monitor) throws Exception {
                    ExplorerViewPart.this.repositoryService.deleteAdaptable(new IAdaptable[]{repositoryObject});
                    return Status.OK_STATUS;
                }
            }, null);
        }
    }

    private void doRemoveAction() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (Object object : selection.toList()) {
            ArrayList<ISecurity> list;
            ScriptStrategy repositoryObject;
            ExplorerViewItem instrumentItem;
            if (object instanceof InstrumentItem) {
                instrumentItem = (InstrumentItem)object;
                repositoryObject = (ScriptStrategy)((InstrumentItem)instrumentItem).getAdapter(ScriptStrategy.class);
                if (repositoryObject == null) continue;
                list = new ArrayList<ISecurity>(Arrays.asList(repositoryObject.getInstruments()));
                list.remove(((InstrumentItem)instrumentItem).getInstrument());
                repositoryObject.setInstruments(list.toArray(new ISecurity[list.size()]));
                this.repositoryService.runInService(new IRepositoryRunnable(){

                    public IStatus run(IProgressMonitor monitor) throws Exception {
                        ExplorerViewPart.this.repositoryService.saveAdaptable(new IAdaptable[]{repositoryObject});
                        return Status.OK_STATUS;
                    }
                }, null);
                continue;
            }
            if (!(object instanceof ScriptItem) || (repositoryObject = (ScriptStrategy)((ScriptItem)(instrumentItem = (ScriptItem)object)).getAdapter(ScriptStrategy.class)) == null) continue;
            list = new ArrayList<IScript>(Arrays.asList(repositoryObject.getIncludes()));
            list.remove(((ScriptItem)instrumentItem).getScript());
            repositoryObject.setIncludes(list.toArray(new IScript[list.size()]));
            this.repositoryService.runInService(new IRepositoryRunnable(){

                public IStatus run(IProgressMonitor monitor) throws Exception {
                    ExplorerViewPart.this.repositoryService.saveAdaptable(new IAdaptable[]{repositoryObject});
                    return Status.OK_STATUS;
                }
            }, null);
        }
    }

    private boolean canEnableDeleteAction(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        for (Object object : selection.toList()) {
            if (object instanceof StrategyItem) continue;
            return false;
        }
        return true;
    }

    private boolean canEnableRemoveAction(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        for (Object object : selection.toList()) {
            if (object instanceof ScriptItem || object instanceof InstrumentItem) continue;
            return false;
        }
        return true;
    }

    private void doAddDroppedObjects(ScriptStrategy strategy, IAdaptable[] contents) {
        boolean dirty = false;
        ArrayList<ISecurity> instruments = new ArrayList<ISecurity>(Arrays.asList(strategy.getInstruments()));
        ArrayList<IScript> scripts = new ArrayList<IScript>(Arrays.asList(strategy.getIncludes()));
        int i = 0;
        while (i < contents.length) {
            IScript script;
            ISecurity security = (ISecurity)contents[i].getAdapter(ISecurity.class);
            if (security != null && !instruments.contains(security)) {
                instruments.add(security);
                dirty = true;
            }
            if ((script = (IScript)contents[i].getAdapter(IScript.class)) != null && !scripts.contains(script)) {
                scripts.add(script);
                dirty = true;
            }
            ++i;
        }
        if (dirty) {
            strategy.setInstruments(instruments.toArray(new ISecurity[instruments.size()]));
            strategy.setIncludes(scripts.toArray(new IScript[scripts.size()]));
            ScriptStrategy repositoryObject = strategy;
            this.repositoryService.runInService(new IRepositoryRunnable((IAdaptable)repositoryObject){
                private final /* synthetic */ IAdaptable val$repositoryObject;
                {
                    this.val$repositoryObject = iAdaptable;
                }

                public IStatus run(IProgressMonitor monitor) throws Exception {
                    ExplorerViewPart.this.repositoryService.saveAdaptable(new IAdaptable[]{this.val$repositoryObject});
                    return Status.OK_STATUS;
                }
            }, null);
        }
    }
}

