/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.ats.explorer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.list.ObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipsetrader.core.ats.IScriptStrategy;
import org.eclipsetrader.core.ats.IStrategy;
import org.eclipsetrader.ui.internal.ats.explorer.ExplorerViewItem;
import org.eclipsetrader.ui.internal.ats.explorer.ExplorerViewItemVisitor;
import org.eclipsetrader.ui.internal.ats.explorer.ExplorerViewModel;

public class StrategyItem
implements ExplorerViewItem {
    private final IStrategy strategy;
    private ExplorerViewModel.InstrumentRootItem instrumentsRoot;
    private ExplorerViewModel.ScriptRootItem scriptsRoot;
    private final List<ExplorerViewItem> list = new ArrayList<ExplorerViewItem>();
    private final WritableList observableChilds = new WritableList(this.list, ExplorerViewModel.ScriptRootItem.class);

    public StrategyItem(IStrategy strategy) {
        this.strategy = strategy;
        this.instrumentsRoot = new ExplorerViewModel.InstrumentRootItem(this);
        this.observableChilds.add((Object)this.instrumentsRoot);
        if (strategy instanceof IScriptStrategy) {
            this.scriptsRoot = new ExplorerViewModel.ScriptRootItem(this);
            this.observableChilds.add((Object)this.scriptsRoot);
        }
    }

    public IStrategy getStrategy() {
        return this.strategy;
    }

    public void update() {
        this.instrumentsRoot.update();
        if (this.scriptsRoot != null) {
            this.scriptsRoot.update();
        }
    }

    @Override
    public ExplorerViewItem getParent() {
        return null;
    }

    @Override
    public boolean hasChildren() {
        return this.observableChilds.size() != 0;
    }

    @Override
    public ObservableList getItems() {
        return this.observableChilds;
    }

    @Override
    public void accept(ExplorerViewItemVisitor visitor) {
        visitor.visit(this);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.strategy.getClass())) {
            return this.strategy;
        }
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public String toString() {
        return this.strategy.getName();
    }
}

