/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.ats.monitor;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.core.internal.ats.TradingSystem;
import org.eclipsetrader.core.internal.ats.TradingSystemProperties;
import org.eclipsetrader.core.trading.IAccount;
import org.eclipsetrader.core.trading.IBroker;
import org.eclipsetrader.core.trading.ITradingService;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.ats.monitor.Messages;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class GeneralProperties
extends PropertyPage
implements IWorkbenchPropertyPage {
    private ComboViewer broker;
    private ComboViewer account;
    private Spinner backfill;
    private Button autostart;
    private final ISelectionChangedListener changeListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            GeneralProperties.this.handleBrokerSelectionChange(selection);
        }
    };

    public GeneralProperties() {
        this.setTitle(Messages.GeneralProperties_General);
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.initializeDialogUnits((Control)content);
        Label label = new Label(content, 0);
        label.setText(Messages.GeneralProperties_Broker);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.broker = new ComboViewer(content, 8);
        this.broker.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.broker.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.broker.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IBroker)element).getName();
            }
        });
        this.broker.setSorter(new ViewerSorter());
        label = new Label(content, 0);
        label.setText(Messages.GeneralProperties_Account);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.account = new ComboViewer(content, 8);
        this.account.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.account.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.account.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IAccount)element).getDescription();
            }
        });
        this.account.setSorter(new ViewerSorter());
        this.account.getControl().setEnabled(false);
        label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        label = new Label(content, 0);
        label.setText(Messages.GeneralProperties_InitialBackfillSize);
        this.backfill = new Spinner(content, 2048);
        this.backfill.setValues(0, 0, 99999, 0, 1, 1);
        label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.autostart = new Button(content, 32);
        this.autostart.setText(Messages.GeneralProperties_StartAutomatically);
        this.autostart.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.performDefaults();
        this.broker.addSelectionChangedListener(this.changeListener);
        return content;
    }

    protected void performDefaults() {
        TradingSystem system = (TradingSystem)this.getElement().getAdapter(TradingSystem.class);
        TradingSystemProperties properties = system.getProperties();
        BundleContext bundleContext = UIActivator.getDefault().getBundle().getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(ITradingService.class);
        ITradingService tradingService = (ITradingService)bundleContext.getService(serviceReference);
        this.autostart.setSelection(properties.isAutostart());
        this.broker.setInput((Object)tradingService.getBrokers());
        if (properties.getBroker() != null) {
            this.broker.setSelection((ISelection)new StructuredSelection((Object)properties.getBroker()));
        } else {
            this.broker.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        this.handleBrokerSelectionChange((IStructuredSelection)this.broker.getSelection());
        if (properties.getAccount() != null) {
            this.account.setSelection((ISelection)new StructuredSelection((Object)properties.getAccount()));
        } else {
            this.account.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        this.backfill.setSelection(properties.getBackfill());
        bundleContext.ungetService(serviceReference);
        super.performDefaults();
    }

    protected void applyChanges() {
        TradingSystem system = (TradingSystem)this.getElement().getAdapter(TradingSystem.class);
        TradingSystemProperties properties = system.getProperties();
        properties.setAutostart(this.autostart.getSelection());
        IStructuredSelection selection = (IStructuredSelection)this.broker.getSelection();
        properties.setBroker((IBroker)selection.getFirstElement());
        selection = (IStructuredSelection)this.account.getSelection();
        properties.setAccount((IAccount)selection.getFirstElement());
        properties.setBackfill(this.backfill.getSelection());
    }

    public boolean isValid() {
        if (this.getErrorMessage() != null) {
            this.setErrorMessage(null);
        }
        return true;
    }

    public boolean performOk() {
        if (this.getControl() != null) {
            this.applyChanges();
        }
        return super.performOk();
    }

    protected void performApply() {
        this.applyChanges();
        super.performApply();
    }

    private void handleBrokerSelectionChange(IStructuredSelection selection) {
        IBroker connector = (IBroker)selection.getFirstElement();
        if (connector != null) {
            IAccount[] accounts = connector.getAccounts();
            ISelection oldSelection = this.account.getSelection();
            this.account.setInput((Object)accounts);
            this.account.setSelection(oldSelection);
            if (this.account.getSelection().isEmpty() && accounts.length != 0) {
                this.account.setSelection((ISelection)new StructuredSelection((Object)accounts[0]));
            }
            this.account.getControl().setEnabled(accounts.length > 0);
        } else {
            this.account.setInput((Object)new Object[0]);
            this.account.getControl().setEnabled(false);
        }
    }
}

