/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.ats.monitor;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.dialogs.FilteredPreferenceDialog;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipsetrader.core.internal.ats.TradingSystem;
import org.eclipsetrader.ui.PriorityPreferenceNode;
import org.eclipsetrader.ui.internal.ats.monitor.GeneralProperties;
import org.eclipsetrader.ui.internal.ats.monitor.Messages;

public class TradingSystemPropertiesHandler
extends AbstractHandler {
    private GeneralProperties generalProperties;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IWorkbenchSite site = HandlerUtil.getActiveSite((ExecutionEvent)event);
        if (selection != null && !selection.isEmpty()) {
            Object target = selection.getFirstElement();
            if (target instanceof IAdaptable) {
                target = ((IAdaptable)target).getAdapter(TradingSystem.class);
            }
            if (target instanceof TradingSystem) {
                this.openPropertiesDialog(site.getShell(), this.getWrappedElement(target));
            }
        }
        return null;
    }

    protected void openPropertiesDialog(Shell shell, final IAdaptable adaptableElement) {
        PropertyPageManager pageManager = new PropertyPageManager();
        this.generalProperties = new GeneralProperties();
        pageManager.addToRoot((IPreferenceNode)new PriorityPreferenceNode("org.eclipsetrader.ui.propertypages.general", (IPreferencePage)this.generalProperties, -1));
        PropertyPageContributorManager.getManager().contribute(pageManager, (Object)adaptableElement);
        for (Object nodeObj : pageManager.getElements(0)) {
            IPreferenceNode node = (IPreferenceNode)nodeObj;
            if (!(node.getPage() instanceof PropertyPage)) continue;
            ((PropertyPage)node.getPage()).setElement(adaptableElement);
        }
        FilteredPreferenceDialog dlg = new FilteredPreferenceDialog(shell, (PreferenceManager)pageManager){

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                TradingSystem element = (TradingSystem)adaptableElement.getAdapter(TradingSystem.class);
                newShell.setText(String.valueOf(Messages.TradingSystemPropertiesHandler_PropertiesFor) + element.getStrategy().toString());
            }
        };
        dlg.setHelpAvailable(false);
        dlg.open();
    }

    protected IAdaptable getWrappedElement(final Object element) {
        if (element instanceof IAdaptable) {
            return (IAdaptable)element;
        }
        return new IAdaptable(){

            public Object getAdapter(Class adapter) {
                if (adapter.isAssignableFrom(element.getClass())) {
                    return element;
                }
                return null;
            }
        };
    }
}

