/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.ats.monitor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipsetrader.core.ats.ITradingSystem;
import org.eclipsetrader.core.ats.ITradingSystemListener;
import org.eclipsetrader.core.ats.ITradingSystemService;
import org.eclipsetrader.core.ats.TradingSystemEvent;
import org.eclipsetrader.ui.internal.ats.ViewColumn;
import org.eclipsetrader.ui.internal.ats.ViewItem;
import org.eclipsetrader.ui.internal.ats.monitor.TradingSystemInstrumentItem;
import org.eclipsetrader.ui.internal.ats.monitor.TradingSystemItem;

public class TradingSystemsViewModel
extends TreeStructureAdvisor
implements IObservableFactory {
    private final ITradingSystemService tradingSystemService;
    private final List<TradingSystemItem> list = new ArrayList<TradingSystemItem>();
    private final WritableList root = new WritableList(this.list, TradingSystemItem.class);
    private final List<ViewColumn> dataProviders = new ArrayList<ViewColumn>();
    private final WritableList columns = new WritableList(this.dataProviders, ViewColumn.class);
    private final ITradingSystemListener tradingSystemListener = new ITradingSystemListener(){

        public void tradingSystemChanged(TradingSystemEvent event) {
            if ((event.getKind() & 1) != 0) {
                TradingSystemsViewModel.this.root.add((Object)new TradingSystemItem(TradingSystemsViewModel.this, event.getTradingSystem()));
            } else if ((event.getKind() & 2) != 0) {
                for (TradingSystemItem tradingSystem : TradingSystemsViewModel.this.list) {
                    if (tradingSystem.getTradingSystem() != event.getTradingSystem()) continue;
                    TradingSystemsViewModel.this.root.remove((Object)tradingSystem);
                    break;
                }
            }
        }
    };

    public TradingSystemsViewModel(ITradingSystemService tradingSystemService) {
        this.tradingSystemService = tradingSystemService;
        ITradingSystem[] iTradingSystemArray = tradingSystemService.getTradeSystems();
        int n = iTradingSystemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITradingSystem tradingSystem = iTradingSystemArray[n2];
            this.root.add((Object)new TradingSystemItem(this, tradingSystem));
            ++n2;
        }
        tradingSystemService.addTradingSystemListener(this.tradingSystemListener);
    }

    public void dispose() {
        this.tradingSystemService.addTradingSystemListener(this.tradingSystemListener);
    }

    public WritableList getObservableDataProviders() {
        return this.columns;
    }

    public List<ViewColumn> getDataProviders() {
        return this.dataProviders;
    }

    public void setDataProviders(List<ViewColumn> list) {
        int i = 0;
        while (i < list.size()) {
            int index = this.columns.indexOf((Object)list.get(i));
            if (index != i) {
                if (index != -1) {
                    this.columns.remove(index);
                }
                this.columns.add(i, (Object)list.get(i));
            } else {
                this.dataProviders.get(index).setName(list.get(index).getName());
            }
            ++i;
        }
        for (ViewColumn column : new ArrayList<ViewColumn>(this.dataProviders)) {
            if (list.contains(column)) continue;
            this.columns.remove((Object)column);
        }
        this.updateAll();
    }

    public List<TradingSystemItem> getList() {
        return this.list;
    }

    public IObservable createObservable(Object target) {
        ObservableList list;
        if (target == this) {
            return Observables.unmodifiableObservableList((IObservableList)this.root);
        }
        if (target instanceof ViewItem && (list = ((ViewItem)target).getItems()) != null) {
            return Observables.unmodifiableObservableList((IObservableList)list);
        }
        return null;
    }

    public void updateAll() {
        for (TradingSystemItem tradingSystemItem : this.list) {
            for (TradingSystemInstrumentItem instrumentItem : tradingSystemItem.getList()) {
                this.updateValues(instrumentItem);
            }
        }
    }

    public void updateValues(TradingSystemInstrumentItem instrumentItem) {
        for (ViewColumn column : this.dataProviders) {
            IAdaptable adaptable = column.getDataProvider().getValue((IAdaptable)instrumentItem);
            if (adaptable == null) continue;
            Object propertyValue = adaptable.getAdapter(String.class);
            if (propertyValue == null) {
                propertyValue = adaptable.getAdapter(Number.class);
            }
            instrumentItem.putValue(column.getDataProviderFactory().getId(), propertyValue);
        }
    }
}

