/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.ats.monitor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipsetrader.core.ats.ITradingSystemService;
import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.internal.ats.TradingSystemProperties;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.ats.ViewColumn;
import org.eclipsetrader.ui.internal.ats.ViewerObservableMap;
import org.eclipsetrader.ui.internal.ats.monitor.Messages;
import org.eclipsetrader.ui.internal.ats.monitor.SettingsAction;
import org.eclipsetrader.ui.internal.ats.monitor.TableDecoratingLabelProvider;
import org.eclipsetrader.ui.internal.ats.monitor.TradingSystemInstrumentItem;
import org.eclipsetrader.ui.internal.ats.monitor.TradingSystemItem;
import org.eclipsetrader.ui.internal.ats.monitor.TradingSystemsViewModel;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class TradingSystemsViewPart
extends ViewPart {
    public static final String VIEW_ID = "org.eclipsetrader.ui.views.ats.monitor";
    static final String COLUMNS = "COLUMNS";
    static final String COLUMN_NAMES = "COLUMN_NAMES";
    static final String COLUMN_WIDTHS = "COLUMN_WIDTHS";
    static final String LABEL_COLUMN = "_label_";
    CoreActivator activator;
    ITradingSystemService tradingSystemService;
    TreeViewer viewer;
    TradingSystemsViewModel model;
    private Action settingsAction;
    IDialogSettings dialogSettings;
    private PropertyChangeListener columnPropertiesChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int index = TradingSystemsViewPart.this.model.getDataProviders().indexOf(evt.getSource());
            if (index != -1) {
                TradingSystemsViewPart.this.viewer.getTree().getColumn(index + 1).setText((String)evt.getNewValue());
            }
        }
    };
    private ControlListener columnControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            IDialogSettings settings = TradingSystemsViewPart.this.dialogSettings.getSection(TradingSystemsViewPart.COLUMN_WIDTHS);
            TreeColumn treeColumn = (TreeColumn)e.widget;
            int index = treeColumn.getParent().indexOf(treeColumn);
            if (index == 0) {
                settings.put(TradingSystemsViewPart.LABEL_COLUMN, treeColumn.getWidth());
            } else {
                ViewColumn viewColumn = TradingSystemsViewPart.this.model.getDataProviders().get(index - 1);
                settings.put(viewColumn.getDataProviderFactory().getId(), treeColumn.getWidth());
            }
        }
    };

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        BundleContext bundleContext = UIActivator.getDefault().getBundle().getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(ITradingSystemService.class);
        this.tradingSystemService = (ITradingSystemService)bundleContext.getService(serviceReference);
        this.activator = CoreActivator.getDefault();
        IDialogSettings rootDialogSettings = UIActivator.getDefault().getDialogSettings();
        this.dialogSettings = rootDialogSettings.getSection(VIEW_ID);
        if (this.dialogSettings == null) {
            this.dialogSettings = rootDialogSettings.addNewSection(VIEW_ID);
            this.dialogSettings.put(COLUMNS, new String[]{"org.eclipsetrader.ui.providers.LastTrade", "org.eclipsetrader.ui.providers.BidPrice", "org.eclipsetrader.ui.providers.AskPrice", "org.eclipsetrader.ui.providers.Position", "org.eclipsetrader.ui.providers.LastTradeDateTime", "org.eclipsetrader.ui.providers.gain"});
            IDialogSettings section = this.dialogSettings.addNewSection(COLUMN_NAMES);
            section.put("org.eclipsetrader.ui.providers.LastTrade", Messages.TradingSystemsViewPart_Last);
            section.put("org.eclipsetrader.ui.providers.BidPrice", Messages.TradingSystemsViewPart_Bid);
            section.put("org.eclipsetrader.ui.providers.AskPrice", Messages.TradingSystemsViewPart_Ask);
            section.put("org.eclipsetrader.ui.providers.Position", Messages.TradingSystemsViewPart_Position);
            section.put("org.eclipsetrader.ui.providers.LastTradeDateTime", Messages.TradingSystemsViewPart_DateTime);
            section.put("org.eclipsetrader.ui.providers.gain", Messages.TradingSystemsViewPart_Gain);
            this.dialogSettings.addNewSection(COLUMN_WIDTHS);
        }
        this.settingsAction = new SettingsAction(site.getShell(), this);
        IActionBars actionBars = site.getActionBars();
        actionBars.setGlobalActionHandler(this.settingsAction.getId(), (IAction)this.settingsAction);
        actionBars.updateActionBars();
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 65538);
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(false);
        this.createContextMenu();
        this.model = new TradingSystemsViewModel(this.tradingSystemService);
        String[] columns = this.dialogSettings.getArray(COLUMNS);
        IDialogSettings namesSection = this.dialogSettings.getSection(COLUMN_NAMES);
        ArrayList<ViewColumn> list = new ArrayList<ViewColumn>();
        int i = 0;
        while (i < columns.length) {
            String name = namesSection.get(columns[i]);
            list.add(new ViewColumn(name, this.activator.getDataProviderFactory(columns[i])));
            ++i;
        }
        this.model.setDataProviders(list);
        for (final TradingSystemItem item : this.model.getList()) {
            PropertyChangeSupport changeSupport = (PropertyChangeSupport)item.getTradingSystem().getAdapter(PropertyChangeSupport.class);
            if (changeSupport == null) continue;
            changeSupport.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).TradingSystemsViewPart.this.viewer.getControl().isDisposed()) {
                                return;
                            }
                            (this).TradingSystemsViewPart.this.viewer.refresh((Object)item);
                        }
                    });
                }
            });
        }
        final ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider((IObservableFactory)this.model, (TreeStructureAdvisor)this.model);
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        IDialogSettings widthSettings = this.dialogSettings.getSection(COLUMN_WIDTHS);
        TreeViewerColumn viewerColumn = new TreeViewerColumn(this.viewer, 0);
        int width = 300;
        if (widthSettings.get(LABEL_COLUMN) != null) {
            width = widthSettings.getInt(LABEL_COLUMN);
        }
        viewerColumn.getColumn().setWidth(width);
        viewerColumn.getColumn().addControlListener(this.columnControlListener);
        final ArrayList<ViewerObservableMap> properties = new ArrayList<ViewerObservableMap>();
        properties.add(new ViewerObservableMap(contentProvider.getKnownElements(), LABEL_COLUMN));
        for (ViewColumn column : this.model.getDataProviders()) {
            viewerColumn = new TreeViewerColumn(this.viewer, 131072);
            viewerColumn.getColumn().setText(column.getName());
            width = 100;
            if (widthSettings.get(column.getDataProviderFactory().getId()) != null) {
                width = widthSettings.getInt(column.getDataProviderFactory().getId());
            }
            viewerColumn.getColumn().setWidth(width);
            viewerColumn.getColumn().addControlListener(this.columnControlListener);
            column.addPropertyChangeListener("name", this.columnPropertiesChangeListener);
            properties.add(new ViewerObservableMap(contentProvider.getKnownElements(), column.getDataProviderFactory().getId()));
        }
        this.createLabelProvider(properties.toArray(new IObservableMap[properties.size()]));
        this.model.getObservableDataProviders().addListChangeListener(new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                event.diff.accept(new ListDiffVisitor(){

                    public void handleRemove(int index, Object element) {
                        TreeColumn treeColumn = (this).TradingSystemsViewPart.this.viewer.getTree().getColumn(index + 1);
                        treeColumn.dispose();
                        ViewColumn column = (ViewColumn)element;
                        column.removePropertyChangeListener("name", TradingSystemsViewPart.this.columnPropertiesChangeListener);
                        IObservableMap observableMap = (IObservableMap)properties.remove(index + 1);
                        if (observableMap != null) {
                            observableMap.dispose();
                        }
                    }

                    public void handleAdd(int index, Object element) {
                        ViewColumn column = (ViewColumn)element;
                        TreeViewerColumn viewerColumn = new TreeViewerColumn((this).TradingSystemsViewPart.this.viewer, 131072, index + 1);
                        viewerColumn.getColumn().setText(column.getName());
                        int width = 100;
                        IDialogSettings widthSettings = (this).TradingSystemsViewPart.this.dialogSettings.getSection(TradingSystemsViewPart.COLUMN_WIDTHS);
                        if (widthSettings.get(column.getDataProviderFactory().getId()) != null) {
                            width = widthSettings.getInt(column.getDataProviderFactory().getId());
                        }
                        viewerColumn.getColumn().setWidth(width);
                        viewerColumn.getColumn().addControlListener(TradingSystemsViewPart.this.columnControlListener);
                        column.addPropertyChangeListener("name", TradingSystemsViewPart.this.columnPropertiesChangeListener);
                        properties.add(index + 1, new ViewerObservableMap(contentProvider.getKnownElements(), column.getDataProviderFactory().getId()));
                    }
                });
                TradingSystemsViewPart.this.createLabelProvider(properties.toArray(new IObservableMap[properties.size()]));
                IDialogSettings namesSection = TradingSystemsViewPart.this.dialogSettings.getSection(TradingSystemsViewPart.COLUMN_NAMES);
                ArrayList<String> list = new ArrayList<String>();
                for (ViewColumn column : TradingSystemsViewPart.this.model.getDataProviders()) {
                    list.add(column.getDataProviderFactory().getId());
                    namesSection.put(column.getDataProviderFactory().getId(), column.getName());
                }
                TradingSystemsViewPart.this.dialogSettings.put(TradingSystemsViewPart.COLUMNS, list.toArray(new String[list.size()]));
            }
        });
        this.viewer.setComparator(new ViewerComparator());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.setInput((Object)this.model);
        this.viewer.expandAll();
    }

    public void dispose() {
        this.model.dispose();
        super.dispose();
    }

    private void createLabelProvider(IObservableMap[] properties) {
        ObservableMapLabelProvider labelProvider = new ObservableMapLabelProvider(properties){

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    if (element instanceof TradingSystemItem) {
                        return UIActivator.getImageFromRegistry("trading-system");
                    }
                    if (element instanceof TradingSystemInstrumentItem) {
                        return UIActivator.getImageFromRegistry("instrument");
                    }
                }
                return super.getColumnImage(element, columnIndex);
            }
        };
        ILabelDecorator labelDecorator = new ILabelDecorator(){
            private final ListenerList listeners = new ListenerList(1);

            public void addListener(ILabelProviderListener listener) {
                this.listeners.add((Object)listener);
            }

            public void removeListener(ILabelProviderListener listener) {
                this.listeners.remove((Object)listener);
            }

            public boolean isLabelProperty(Object element, String property) {
                return TradingSystemsViewPart.LABEL_COLUMN.equals(property);
            }

            public void dispose() {
                this.listeners.clear();
            }

            public String decorateText(String text, Object element) {
                if (element instanceof TradingSystemItem) {
                    StringBuilder sb = new StringBuilder();
                    TradingSystemItem item = (TradingSystemItem)element;
                    switch (item.getTradingSystem().getStatus()) {
                        case 1: {
                            sb.append(Messages.TradingSystemsViewPart_Starting);
                            break;
                        }
                        case 2: {
                            sb.append(Messages.TradingSystemsViewPart_Started);
                            break;
                        }
                        case 3: {
                            sb.append(Messages.TradingSystemsViewPart_Stopping);
                            break;
                        }
                        case 4: {
                            sb.append(Messages.TradingSystemsViewPart_Stopped);
                        }
                    }
                    TradingSystemProperties properties = (TradingSystemProperties)item.getTradingSystem().getAdapter(TradingSystemProperties.class);
                    if (properties != null && properties.isAutostart()) {
                        if (sb.length() != 0) {
                            sb.append(", ");
                        }
                        sb.append(Messages.TradingSystemsViewPart_Autostart);
                    }
                    if (sb.length() != 0) {
                        sb.insert(0, " [");
                        sb.append("]");
                    }
                    return String.valueOf(text) + sb.toString();
                }
                return text;
            }

            public Image decorateImage(Image image, Object element) {
                return null;
            }
        };
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableDecoratingLabelProvider((ILabelProvider)labelProvider, labelDecorator));
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#popupMenu", "popupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.add((IContributionItem)new Separator("group.new"));
                menuManager.add((IContributionItem)new GroupMarker("group.goto"));
                menuManager.add((IContributionItem)new Separator("group.open"));
                menuManager.add((IContributionItem)new GroupMarker("group.openWith"));
                menuManager.add((IContributionItem)new Separator("group.trade"));
                menuManager.add((IContributionItem)new GroupMarker("group.tradeWith"));
                menuManager.add((IContributionItem)new Separator("group.show"));
                menuManager.add((IContributionItem)new Separator("group.edit"));
                menuManager.add((IContributionItem)new GroupMarker("group.reorganize"));
                menuManager.add((IContributionItem)new GroupMarker("group.port"));
                menuManager.add((IContributionItem)new Separator("group.generate"));
                menuManager.add((IContributionItem)new Separator("group.search"));
                menuManager.add((IContributionItem)new Separator("group.build"));
                menuManager.add((IContributionItem)new Separator("additions"));
                menuManager.add((IContributionItem)new Separator("group.properties"));
                menuManager.appendToGroup("group.show", (IAction)new Action(Messages.TradingSystemsViewPart_ExpandAll){

                    public void run() {
                        IStructuredSelection selection = (IStructuredSelection)(this).TradingSystemsViewPart.this.viewer.getSelection();
                        Iterator iter = selection.iterator();
                        while (iter.hasNext()) {
                            (this).TradingSystemsViewPart.this.viewer.expandToLevel(iter.next(), -1);
                        }
                    }
                });
            }
        });
        this.viewer.getControl().setMenu(menuMgr.createContextMenu(this.viewer.getControl()));
        this.getSite().registerContextMenu(menuMgr, this.getSite().getSelectionProvider());
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(((Object)((Object)this.model)).getClass())) {
            return this.model;
        }
        return super.getAdapter(adapter);
    }
}

