/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.ats.wizards;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.core.ats.IStrategy;
import org.eclipsetrader.core.ats.ScriptStrategy;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.ats.SaveAdaptableHelper;
import org.eclipsetrader.ui.internal.ats.wizards.Messages;
import org.eclipsetrader.ui.internal.views.SecuritySelectionControl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class InstrumentsProperties
extends PropertyPage
implements IWorkbenchPropertyPage {
    private SecuritySelectionControl providers;

    public InstrumentsProperties() {
        this.setTitle(Messages.InstrumentsProperties_Instruments);
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.initializeDialogUnits((Control)content);
        BundleContext bundleContext = UIActivator.getDefault().getBundle().getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(IRepositoryService.class);
        IRepositoryService repositoryService = (IRepositoryService)bundleContext.getService(serviceReference);
        this.providers = new SecuritySelectionControl(content);
        this.providers.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.providers.setInput(repositoryService.getSecurities());
        bundleContext.ungetService(serviceReference);
        this.performDefaults();
        return content;
    }

    protected void performDefaults() {
        IStrategy strategy = (IStrategy)this.getElement().getAdapter(IStrategy.class);
        this.providers.setSelectedColumns(strategy.getInstruments());
        super.performDefaults();
    }

    protected void applyChanges() {
        ScriptStrategy strategy = (ScriptStrategy)this.getElement().getAdapter(ScriptStrategy.class);
        if (strategy != null) {
            strategy.setInstruments(this.providers.getSelection());
        }
    }

    public boolean isValid() {
        if (this.getErrorMessage() != null) {
            this.setErrorMessage(null);
        }
        return true;
    }

    public boolean performOk() {
        if (this.getControl() != null) {
            this.applyChanges();
        }
        return super.performOk();
    }

    protected void performApply() {
        this.applyChanges();
        SaveAdaptableHelper.save(this.getElement());
        super.performApply();
    }
}

